<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class Rule extends Model
{
    use ValidatesFields;

    const PARTICIPANT_MODE_ALL = 1;
    const PARTICIPANT_MODE_SPECIFIC = 2;

    const OFFER_MODE_ALL = 1;
    const OFFER_MODE_SPECIFIC = 2;

    const VALUE_TYPE_FIXED = 1;
    const VALUE_TYPE_PERCENT = 2;

    const VALUE_SOURCE_OFFER = 1;
    const VALUE_SOURCE_RULE_SINGLE = 2;
    const VALUE_SOURCE_RULE_BY_PARTICIPANT = 3;
    const VALUE_SOURCE_RULE_SINGLE_RUNNING_BALANCE = 4;
    const VALUE_SOURCE_RULE_BY_PARTICIPANT_RUNNING_BALANCE = 5;

    /**
     * The table name.
     * @var string
     */
    protected $table = 'claim_rule';

    /**
     * The primary key.
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The field declarations.
     * @var array
     */
    public static $fields = [
        'id'                   => ['type' => 'integer'],
        'name'                 => ['type' => 'string'],
        'offer_promotion_id'   => ['type' => 'integer'],
        'value_mode_id'        => ['type' => 'integer', 'default' => '1'],
        'value_type_id'        => ['type' => 'integer', 'default' => '1'],
        'value'                => ['type' => 'float', 'default' => '0'],
        'max_times'            => ['type' => 'integer', 'default' => '0'],
        'offers_mode_id'       => ['type' => 'integer', 'default' => '1'],
        'participants_mode_id' => ['type' => 'integer', 'default' => '1'],
        'start_date'           => ['type' => 'date'],
        'end_date'             => ['type' => 'date'],
        'order'                => ['type' => 'integer', 'default' => '0'],
        'status'               => ['type' => 'integer', 'default' => '0'],
    ];

    /**
     * The value source option declarations.
     * @var array
     */
    public static $valueSourceOptions = [
        self::VALUE_SOURCE_OFFER => 'From Offer',
        self::VALUE_SOURCE_RULE_SINGLE => 'Rule Single Value',
        self::VALUE_SOURCE_RULE_BY_PARTICIPANT => 'Rule Values by Participant',
        self::VALUE_SOURCE_RULE_SINGLE_RUNNING_BALANCE => 'Running Balance Single',
        self::VALUE_SOURCE_RULE_BY_PARTICIPANT_RUNNING_BALANCE => 'Running Balance by Participant',
    ];

    /**
     * The value type option declarations.
     * @var array
     */
    public static $valueTypeOptions = [
        self::VALUE_TYPE_FIXED   => 'Fixed Amount',
        self::VALUE_TYPE_PERCENT => 'Percentage Amount',
    ];

    /**
     * The select mode option declarations.
     * @var array
     */
    public static $selectModeOptions = [
        1 => 'All',
        2 => 'Select',
    ];

    /**
     * The relationship to the OfferPromotion model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotion()
    {
        return $this->belongsTo('Ignite\Claim\Entities\OfferPromotion', 'offer_promotion_id');
    }

    /**
     * The relationship to the RuleParticipants model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function participants()
    {
        return $this->hasMany('Ignite\Claim\Entities\RuleParticipant', 'rule_id');
    }

    /**
     * The relationship to the RuleOffer model.
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function offers()
    {
        return $this->hasMany('Ignite\Claim\Entities\RuleOffer', 'rule_id');
    }

    /**
     * The relationship to the RuleConditions model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function conditions()
    {
        return $this->hasMany('Ignite\Claim\Entities\RuleCondition', 'rule_id');
    }

    /**
     * The relationship to the RuleValues model.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function values()
    {
        return $this->hasMany('Ignite\Claim\Entities\RuleValue', 'rule_id');
    }
}
