<?php

namespace Ignite\Claim\Models\Dashboard\Charts;

use Illuminate\Support\Facades\DB;
use Ignite\Core\Models\Dashboard\CorrelatedStat;

class ClaimsDeclinedStat extends CorrelatedStat
{
    /**
     * Create a new stat instance.
     *
     * @param  array|object $attributes
     */
    public function __construct($attributes = [])
    {
        $attributes = array_merge([
            'label' => 'Claims Declined',
            'color' => 'red',
            'icon'  => 'ion ion-ios-close-outline',
            'link'  => url('/admin/claim/list/declined'),
            'sort'  => 4
        ], $attributes);

        parent::__construct($attributes);
    }

    /**
     * The chart size in the layout.
     *
     * @return string
     */
    public function getSize()
    {
        return $this->get('size', 'col-xs-6 col-sm-3');
    }

    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement()
    {
        return 'claims-declined-stat';
    }

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData()
    {
        if (! $this->get('data', false)) {
            /**
             * @var \Carbon\Carbon $start
             * @var \Carbon\Carbon $end
             */
            list($start, $end) = $this->getDateRange();

            $this->attributes['data'] = DB::query()
                ->select(DB::raw('COUNT(id) as total'))
                ->from('claim_participant')
                ->where('status', '=', 'declined')
                ->whereBetween('created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
                ->whereNull('deleted_at')
                ->count();

            $this->attributes['total'] = DB::query()
                ->select(DB::raw('COUNT(id) as total'))
                ->from('claim_participant')
                ->whereNull('deleted_at')
                ->whereBetween('created_at', [$start->format('Y-m-d H:i:s'), $end->format('Y-m-d H:i:s')])
                ->count();

            $this->attributes['percentage'] = $this->calculatePercentage();
        }

        return $this->get('data');
    }
}
