<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class OfferUserPromotionGroup extends Model
{
	use ValidatesFields;

	/** @var string */
    protected $table = 'claim_offer_user_promotion_group';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    public static $fields = [
        'id' => ['type' => 'integer'],
        'user_id' => ['type' => 'integer'],
        'promotion_group_id' => ['type' => 'integer'],
    ];

    /**
     * The promotion group relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotionGroup()
    {
        return $this->belongsTo(OfferPromotionGroup::class, 'promotion_group_id', 'id');
    }
}
