@extends('Claim::admin.offers.layouts.master')

@section('page_heading', 'Offers')
@section('page_breadcrumb', 'Offers')

@section('tab_before')
    <div id="offersVue">
@endsection

@section('tab_content')
    <div class="row">
        @if (count($promotions) > 0)
            <div class="col-xs-4">
                <button type="button" class="btn btn-default" @click.prevent="newOffer()"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
            </div>
        @endif
        <div class="col-xs-8">
            @if (count($campaigns) > 1)
                <div class="col-xs-4 pull-right">
                    <label for="campaignId" class="input-group-addon">Campaign</label>
                    <select class="form-control select2" name="campaignId" id="campaignId">
                        @foreach($campaigns as $campaign)
                            <option value="{{ $campaign['id'] }}" @if ($campaign['id'] == "$campaignId")selected="selected"@endif>{{ $campaign['name'] }}</option>
                        @endforeach
                    </select>
                </div>
            @elseif (count($campaigns) == 1)
                @php ($campaign = reset($campaigns))
                <div class="input-group hidden">
                    <input type="hidden" id="campaignId" name="campaignId" value="{{ $campaign['id'] }}"/>
                </div>
            @else
                <div class="input-group hidden">
                    <input type="hidden" id="campaignId" name="campaignId" value="1"/>
                </div>
            @endif

            @if (count($promotions) > 0)
                <div class="col-xs-4 input-group pull-right">
                    <label for="promotionId" class="input-group-addon">Promotion:&nbsp;</label>
                    <select class="form-control select2" name="promotionId" id="promotionId">
                        @foreach($promotions as $promotion)
                            <option value="{{ $promotion['id'] }}" @if ($promotion['id'] == "$promotionId")selected="selected"@endif>{{ $promotion['name'] }}</option>
                        @endforeach
                    </select>
                </div>
            @else
                <div class="col-xs-4 input-group pull-right">
                    <label for="promotionId" class="input-group-addon">Promotion:&nbsp;</label>
                    <select class="form-control select2" name="promotionId" id="promotionId">
                        <option value="">-- please create a promotions first --</option>
                    </select>
                </div>
            @endif
        </div>
    </div>
    <hr />
    @if (! empty($offers))
    <table class="table table-bordered table-responsive table-data table-striped" id="offersTable">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th>#</th>
                <th>Offer Group</th>
                <th>Name</th>
                <th>SKU</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Grace Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
        @forelse($offers as $offer)
            <tr>
                <td class="text-right text-nowrap" width="{{ empty($offer['has_claims']) ? '100' : '50' }}">
                    <button type="button" class="btn btn-sm btn-default" @click.prevent="editOffer({{ $offer['id'] }})" >Edit</button>
                    @if (empty($offer['has_claims']))
                        <button type="button" class="btn btn-sm btn-danger" @click.prevent="deleteOffer({{ $offer['id'] }})">Delete</button>
                    @endif
                </td>
                <td>{{ $offer['id'] }}</td>
                <td>{{ $offer['offer_group'] }}</td>
                <td>{{ $offer['name'] }}</td>
                <td>{{ $offer['sku'] }}</td>
                <td>{{ !$offer['start_date'] ? 'Beginning of Time' : Format::date($offer['start_date']) }}</td>
                <td>{{ !$offer['start_date'] ? 'End of Time' : Format::date($offer['end_date']) }}</td>
                <td>{{ !$offer['grace_date'] ? ' None' : Format::date($offer['grace_date']) }}</td>
                <td>{{ ($offer['status'] == 1) ? 'Active' : 'Inactive' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="10" class="text-danger text-center">No offers defined for the selected promotion.</td>
            </tr>
        @endforelse
        </tbody>
    </table>
    @endif
    <!-- Edit Offer Modal -->
    <div class="modal" id="offerEditDialog" tabindex="-1" role="dialog" aria-labelledby="offerEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h3 class="modal-title" id="offerEditLabel">Maintain Offer</h3>
                </div>
                <div class="modal-body">
                    <form>
                        {{ csrf_field() }}
                        <input type="hidden" id="offerId" value="" v-model="offerId">
                        <input type="hidden" id="offerAction" value="">
                        <input type="hidden" id="editPromotionId" value="" />

                        <div class="form-group">
                            <label for="offerName">Name</label>
                            <input class="form-control" id="offerName" placeholder="Enter Offer Name" v-model="offer.name" required>
                        </div>

                        <div class="form-group">
                            <label for="offerSku">SKU</label>
                            <input class="form-control" id="offerSku" v-model="offer.sku">
                        </div>

                        <div class="form-group">
                            <label for="offerGroup">Offer Group</label>
                            <input class="form-control" id="offerGroup" v-model="offer.offer_group">
                        </div>

                        <div class="form-group">
                            <label for="offerDescription">Description</label>
                            <textarea class="form-control" id="offerDescription" rows="3" v-model="offer.description"></textarea>
                        </div>

                        <div class="form-group row" style="margin-right: 20px;">
                            <div class="form-inline">
                                <div class="col-md-4">
                                    <label for="offerStartDate text-nowrap">Start Date</label>
                                    <!--
                                    <input type="text" id="offerStartDate" class="form-control datepicker" v-model="offer.start_date" v-on:input="updateDateValue($event.target.value)" />
                                    -->
                                    <input type="text" id="offerStartDate" class="form-control datepicker" v-model="offer.start_date" />
                                </div>
                                <div class="col-md-4">
                                    <label for="offerEndDate text-nowrap">End Date</label>
                                    <input type="text" id="offerEndDate" class="form-control datepicker" v-model="offer.end_date" />
                                </div>
                                <div class="col-md-4">
                                    <label for="offerGraceDate text-nowrap">Grace Date</label>
                                    <input type="text" id="offerGraceDate" class="form-control datepicker" v-model="offer.grace_date" />
                                </div>
                            </div>
                        </div>

                        <div class="form-check">
                        </div>

                        <div class="form-group row">
                            <div class="form-inline">
                                <div class="col-md-1"></div>
                                <label class="form-check-label col-md-2">
                                    <input type="checkbox" class="form-check-input" id="offerStatus" value="1" v-model="offer.status" >
                                    Active
                                </label>
                                <div class="col-md-6">
                                    <label class="" for="offerValueModeId">Value Mode:</label>
                                    &nbsp;&nbsp;&nbsp;
                                    <div class="checkbox">
                                        <label>
                                            <input type="radio" name="offerValueModeId" value="1" v-model="offer.value_mode_id"> Single
                                        </label>
                                    </div>
                                    &nbsp;&nbsp;&nbsp;
                                    <div class="checkbox">
                                        <label>
                                            <input type="radio" name="offerValueModeId" value="2" v-model="offer.value_mode_id"> Multiple
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row hidden" id="singleValueDiv" style="margin: 1px;">
                            <div class="panel panel-default">
                                <div class="panel-heading"><b>Single Value</b></div>
                                <div class="panel-body">
                                    <div class="form-group row">
                                        <label class="col-md-4" for="value">Value Type:</label>
                                        <div class="col-md-4">
                                            <select class="form-control" size="1" id="offerValueTypeId" name="offerValueTypeId"  v-model="offer.value_type_id" >
                                                @foreach($valueTypeOptions as $value => $text)
                                                    <option value="{{ $value }}">{{ $text }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-md-4" for="offerValue">Value:</label>
                                        <div class="col-md-4">
                                            <input type="text" class="form-control" id="offerValue" name="offerValue" value="" v-model="offer.value" required>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row hidden" id="multipleValuesDiv" style="margin: 1px;">
                            <div class="panel panel-default">
                                <div class="panel-heading"><b>Values by Participant</b></div>
                                <div class="panel-body">
                                    <table class="table" id="valuesList">
                                        <thead class="thead-default">
                                        <tr>
                                            <th>Participant</th>
                                            <th>Value Type</th>
                                            <th>Value</th>
                                            <th class="text-right">
                                                <a type="button" class="btn btn-sm btn-success" id="newValue" @click.prevent="newValue()">New Value</a>
                                            </th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr v-for="(valueItem, index) in offer.values" :key="index">
                                            <td>@{{ valueItem.participant_type }}</td>
                                            <td>@{{ renderValueType(valueItem.value_type_id) }}</td>
                                            <td>@{{ valueItem.value }}</td>
                                            <td class="text-right text-nowrap">
                                                <a type="button" class="btn btn-sm btn-default" @click.prevent="editValue(valueItem, index)">Edit</a>
                                                <a type="button" class="btn btn-sm btn-danger" @click.prevent="deleteValue(index)">Delete</a>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>

                                </div>
                                <!-- panel-body  -->
                            </div>
                            <!-- panel -->
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="offerSave" @click.prevent="saveOffer()">Save</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Value Dialog -->
    <div class="modal " id="valueEditDialog" tabindex="-1" role="dialog" aria-labelledby="valueEditLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 class="modal-title" id="valueEditLabel">Maintain Value</h2>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                    <form method="POST" enctype="multipart/form-data">

                        <input type="hidden" id="valueIndex" v-model="editValueIndex" />
                        <input type="hidden" id="valueId" v-model="editValueItem.id" />

                        <div class="form-group">
                            <label for="valueName">Type</label>
                            <select class="form-control" style="display: block; width: 100%;" id="valueName"  v-model="editValueItem.participant_type" >
                                <option value="">-- Select --</option>
                                @foreach($participantTypes as $value => $text)
                                    <option value="{{ $value }}">{{ $text }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="valueType">Mode</label>
                            <select class="form-control" style="display: block; width: 100%;" id="valueType"  v-model="editValueItem.value_type_id" >
                                @foreach($valueTypeOptions as $value => $text)
                                    <option value="{{ $value }}">{{ $text }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="valueValue">Value</label>
                            <input class="form-control" id="valueValue" v-model="editValueItem.value" >
                        </div>

                    </form>

                </div>
                <!-- modal-body -->

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-success hidden" id="valueAdd" @click.prevent="addValue()">Add</button>
                    <!--
                            <button type="button" class="btn btn-danger hidden" id="valueDelete">Delete</button>
                    -->
                    <button type="button" class="btn btn-primary hidden" id="valueSave" @click.prevent="updateValue(editValueIndex)">Save</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('tab_after')
    </div>
    <!-- offersVue End -->
@endsection

@section('js')
    @parent
    @include('Claim::partials.vue');
    <script type="text/javascript">
        var valueTypeOptions = {!! json_encode($valueTypeOptions, JSON_PRETTY_PRINT); !!};
        $(document).ready(function() {
            function updatePromotionSelect(campaignId) {
                $.ajax({
                    type: 'GET',
                    url: '/offer/api/promotion/forcampaign/' + campaignId,
                    dataType: 'json',
                    success: function(result){
                        var promotions = result.data;
                        var promotionId = 0;
                        $('#promotionId').empty();
                        for(var ii in promotions) {
                            var option = '<option value="' + promotions[ii]['id'] + '">' + promotions[ii]['name'] + '</option>';
                            $('#promotionId').append(option);
                            if ( promotionId == 0 ) {
                                promotionId = promotions[ii]['id'];
                            }
                        };

                        var url = '/admin/offer/offers/' + promotionId + '/' + campaignId;
                        window.location.replace(url);
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        var messages = window.Ignite.Core.getResponseErrors(xhr, 'xhr.responseJSON.messages');
                        alert('Unable to get Promotions for Campaign id = ' + campaignId + "\n" + messages + xhr.status + ': ' + thrownError);
                    }
                });
            }

            $('#campaignId').change(function() {
                var campaignId = $('#campaignId').val();
                updatePromotionSelect(campaignId);
            });

            $('#promotionId').change(function() {
                var promotionId = $('#promotionId').val();
                var url = '/admin/offer/offers/' + promotionId;
                window.location.replace(url);
            });

            $('[name="offerValueModeId"]').change(function() {
                if ( $(this).val() == '2' ) {
                    $('#singleValueDiv').addClass('hidden');
                    $('#multipleValuesDiv').removeClass('hidden');
                }
                else {
                    $('#multipleValuesDiv').addClass('hidden');
                    $('#singleValueDiv').removeClass('hidden');
                }
            });

            $('.datepicker').datepicker({
                format: 'mm/dd/yyyy',
                autoclose: true,
                pickDate: true
            }).on('show.bs.modal', function(event) {
                // Prevent datepicker from firing bootstrap modal "show.bs.modal"
                event.stopPropagation();
            });

            $('#offersTable').DataTable({
                columnDefs: [{orderable: false, targets: [9] }],
                order: [[2, 'asc']],
            });

        });
    </script>
    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/offer/offer.js') }}"></script>
@endsection
