<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;

class Translation extends Model
{
    /**
     * Table name.
     *
     * @var string
     */
    protected $table = 'claim_translation';

    /**
     * TODO: What is this? Why is it false?
     * @var bool
     */
    private static $translations = false;

    /**
     * TODO: Why is this false?
     * @var bool
     */
    private static $translationsLookup = false;

    /**
     * Find a translation by key.
     *
     * @todo  Move to a repository class
     * @param  string $key
     * @param  bool   $asLookup
     * @return array|bool|mixed|static
     */
    public static function byKey($key, $asLookup = false)
    {
        if (! self::$translations) {
            self::$translations = static::all();
    
            self::$translationsLookup = [];
            foreach (self::$translations as $translation) {
                self::$translationsLookup[$translation->key] = $translation;
            }
        }
    
        if (strpos($key, '*') !== false) {
            $result = self::$translations->filter(function ($translation) use ($key) {
                return preg_match("~$key~", $translation->key);
            });
        } else {
            return (! empty(self::$translationsLookup[$key])) ? self::$translationsLookup[$key] : false;
        }

        $lookup = [];
        if ($asLookup) {
            foreach ($result as $status) {
                $lookup[$status->key] = $status->value;
            }

            return $lookup;
        }

        return $result;
    }
}
