<?php

namespace Ignite\Claim\Events\Handlers\Participants;

use Ignite\Claim\Entities\Claim;
use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Entities\File;
use Ignite\Claim\Entities\OfferUserPromotionGroup;
use Ignite\Core\Events\EnrollmentDeleting;

class DeleteClaimRelationsWhenDeletingParticipant
{
    /**
     * Handle deleting claim data related to the participant being deleted.
     *
     * @param  EnrollmentDeleting $event
     * @throws \DomainException
     */
    public function handle(EnrollmentDeleting $event)
    {
        $participant = $event->getParticipant();
        $participantId = (int) $participant->getKey();

        $claims = ClaimParticipant::query()
            ->where('user_id', $participantId)
            ->whereIn('status', ['approved', 'issued'])
            ->count();

        if ($claims > 0) {
            throw new \DomainException(
                "You cannot delete participant with approved or issued claims. ID: {$participantId}"
            );
        }

        ClaimParticipant::query()->where('user_id', $participantId)->delete();
        Claim::query()->where('user_id', $participantId)->delete();
        File::query()->where('user_id', $participantId)->delete();
        OfferUserPromotionGroup::query()->where('user_id', $participantId)->delete();
    }
}