<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class RuleOffer extends Model
{
	use ValidatesFields;

	/**
	 * The table name.
	 * @var string
	 */
	protected $table = 'claim_rule_offer';

	/**
	 * The primary key.
	 * @var string
	 */
	protected $primaryKey = 'id';

	/**
	 * The fields declaration.
	 * @var array
	 */
    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'rule_id'               => [ 'type' => 'integer'],
        'offer_id'              => [ 'type' => 'integer'],
    ];

	/**
	 * The relationship to the Rule model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
    public function rule()
    {
        return $this->belongsTo(Rule::class, 'rule_id');
    }

	/**
	 * The relationship to the OfferValue model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\HasMany
	 */
    public function values()
    {
        return $this->hasMany(OfferValue::class, 'offer_id', 'offer_id');
    }

	/**
	 * The relationship to the OfferRule model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
    public function offer()
    {
        return $this->belongsTo(OfferRule::class, 'offer_id');
    }
}
