<?php

namespace Ignite\Claim\Entities;

use Ignite\Claim\Entities\Dynamic\DynamicModel;
use Ignite\Claim\Traits\ValidatesFields;

class Offer extends DynamicModel
{
	use ValidatesFields;

	const TABLE_KEY = 'table.columns.offer';

	const VALUE_TYPE_FIXED = 1;
    const VALUE_TYPE_PERCENT = 2;

    const VALUE_MODE_SINGLE = 1;
    const VALUE_MODE_MULTIPLE = 2;

	/** @var string */
    protected $table = 'claim_offer';

    /** @var string */
    protected $primaryKey = 'id';

    /** @var array */
    public static $fields = [
        'id'            => ['type' => 'integer'],
        'promotion_id'  => ['type' => 'integer'],
        'name'          => ['type' => 'string'],
        'description'   => ['type' => 'string'],
        'offer_number'  => ['type' => 'string'],
        'offer_group'   => ['type' => 'integer'],
        'sku'           => ['type' => 'integer'],
        'value_mode_id' => ['type' => 'integer', 'default' => '1'],
        'value_type_id' => ['type' => 'integer', 'default' => '1'],
        'value'         => ['type' => 'integer', 'default' => '0'],
        'show_order'    => ['type' => 'integer', 'default' => '0'],
        'start_date'    => ['type' => 'date'],
        'end_date'      => ['type' => 'date'],
        'grace_date'    => ['type' => 'date'],
        'status'        => ['type' => 'integer', 'default' => '1'],
        'archived'      => ['type' => 'integer', 'default' => '0'],
    ];

    /**
     * Get the related values.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function values()
    {
        return $this->hasMany(OfferValue::class, 'offer_id');
    }

    /**
     * Get the related promotion.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function promotion()
    {
        return $this->belongsTo(OfferPromotion::class, 'promotion_id', 'id');
    }
}
