<?php

/** @var \Illuminate\Database\Eloquent\Factory $factory */

use Ignite\Claim\Entities\OfferPromotion;

$factory->define(\Ignite\Claim\Entities\Claim::class, function (\Faker\Generator $faker) {

    $participant = factory(\Ignite\Core\Entities\Participant::class, 1)->create()->first();

    return [
        "user_id" => $participant->user_id,
        'offer_promotion_id' => factory(OfferPromotion::class),
        "claim_type" => null,
        "prm_number" => null,
        "estimated_revenue" => null,
        "deal_registration_date" => null,
        "distributor_po_number" => null,
        "revenue_sold" => 0,
        "activity_date" => $faker->date('Y-m-d'),
        "sale_value" => 0,
        "customer_name" => "Avaya",
        "customer_contact_first" => "John",
        "customer_contact_last" => "Smith",
        "customer_contact_title" => "Mr",
        "customer_contact_phone" => "01234567890",
        "customer_contact_email" => null,
        "support_file" => null,
        "user_notes" => null,
        "customer_address_1" => "Test",
        "customer_address_2" => "Test",
        "customer_city" => "Test",
        "customer_state" => "TX",
        "customer_postal" => "75001",
        "customer_country" => "US",
        "date_submitted" => null,
        "archived" => 0,
        "created_at" => $faker->date('Y-m-d H:i:s'),
        "updated_at" => $faker->date('Y-m-d H:i:s'),
    ];
});
