<?php

namespace Ignite\Claim\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Ignite\Core\Models\Menu\Item;
use Ignite\Core\Models\Menu\NavigationMenu;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class AddClaimItemsToNavigationMenu
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ModuleRepository $moduleRepository)
    {
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param NavigationMenuPreCompile|UserMenuPreCompile $event
     *
     * @throws \Nwidart\Modules\Exceptions\ModuleNotFoundException
     */
    public function handle($event)
    {
        if ($this->moduleRepository->isDisabled('Claim')) {
            return;
        }

        /** @var NavigationMenu $manager */
        $manager = $event->getManager();

        $item = new Item(url('/claim'), 'My Claims', 30);

        if ($manager->has('/participant/profile') && $event instanceof NavigationMenuPreCompile) {
            $manager->get('/participant/profile')->addChild($item);
        }

        if ($event instanceof UserMenuPreCompile) {
            $manager->add($item);
        }
    }
}
