@extends('Claim::admin.rules.layouts.master')

@section('page_heading', 'Rule Sets')
@section('page_breadcrumb', 'Rule Sets')

@section('page_content')
    <div id="ruleListVue">
        <div class="box box-primary">
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-6">
                        <a type="button" class="btn btn-default" href="{{ url('/admin/rule/edit/new') . '/' . $promotionId }}"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></a>
                    </div>
                </div>
                <hr />
                <table class="table table-bordered table-striped">
                    <thead class="thead-default">
                        <tr>
                            <th class="text-left">&nbsp;</th>
                            <th>#</th>
                            <th>Name</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Max Times</th>
                            <th>Offers Applied</th>
                            <th>Participants Applied</th>
                            <th>Value Type</th>
                            <th>Value Source</th>
                            <th>Value</th>
                            <th>Conditions</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                    @if (count($rules) > 0)
                        <tr class="bg-white" v-for="(rule, index) in rules" data-id="rule.id" data-index="index">
                            <td class="text-right text-nowrap" nowrap width="10">
                                <a class="btn btn-sm btn-default" data-toggle="modal" :href="'/admin/rule/edit/' + rule.id">Edit Rule</a>
                                <button class="btn btn-sm btn-default" data-toggle="modal" data-target="#testRulesDialog" data-id="rule.id">Test</button>
                                <button class="btn btn-sm btn-default" :data-href="'/admin/rule/delete/' + rule.id + '{{ '/' . $promotionId }}'" @click="confirmDelete(index, $event)"><span class=" text-danger">Delete</span></button>
                            </td>
                            <td data-id>@{{ rule.id }}</td>
                            <td data-name>@{{ rule.name }}</td>
                            <td data-start_date>@{{ renderStartDate(index) }}</td>
                            <td data-end_date>@{{ renderEndDate(index) }}</td>
                            <td>@{{ rule.max_times }}</td>
                            <td>@{{ rule.offers_mode_id == 1 ? 'All' : rule.offers.length }} Offer(s)</td>
                            <td>@{{ rule.participants_mode_id == 1 ? 'All' : rule.participants.length }} Participant(s)</td>
                            <td>@{{ rule.value_type_id == 1 ? 'Fixed Amount' : 'Percentage' }}</td>
                            <td>@{{ source(rule) }}</td>
                            <td>@{{ value(rule) }}</td>
                            <td>@{{ rule.conditions.length || 'None' }}</td>
                            <td>@{{ renderStatus(index) }}</td>
                        </tr>
                    @else
                        <tr>
                            <td colspan="10" class="text-center text-danger">No rule sets defined.</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button class="close" data-dismiss="modal">&times;</button>
                    <h4 class="text-danger">Delete Rule</h4>
                </div>
                <div class="modal-body" v-html="confirmDeleteMessage">
                    <p>Be warned, this is a permanent action, you will be unable to retrieve this data.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-danger btn-ok pull-right" on.click=confirmDelete">Confirm</a>
                </div>
            </div>
        </div>
    </div>

    @include('Claim::admin.rules.ruleTestDialog')

@endsection

@section('js')
    @parent
    @include('Claim::partials.vue')
    <script>

        allRulesSelect = {!! json_encode($allRulesSelect, JSON_PRETTY_PRINT) !!} ;
        testRules = {!! json_encode([], JSON_PRETTY_PRINT) !!} ;
        claimsSelect = {!! json_encode($claimsSelect, JSON_PRETTY_PRINT) !!} ;

        var ruleListVue = new Vue({
            el: '#ruleListVue',
            data: {
                confirmDeleteMessage: "Are you sure you want to delete this Rule?\n<br />\nThis cannot be undone!",
                rules: {!! json_encode($rules, JSON_PRETTY_PRINT) !!}
            },
            methods : {
                renderStartDate: function(index) {
                    var startDate = ( parseInt(this.rules[index].start_date) > 0 ) ? moment(this.rules[index].start_date).format('M/D/YYYY') : 'None';
                    return startDate;
                },
                renderEndDate: function(index) {
                    var endDate = ( parseInt(this.rules[index].end_date) > 0 ) ? moment(this.rules[index].end_date).format('M/D/YYYY') : 'None';
                    return endDate;
                },
                renderStatus: function(index) {
                    return ( this.rules[index].status ) ? 'Active' : 'Inactive';
                },
                source: function (rule) {
                  if (rule.value_mode_id == '1') {
                    return 'From Offer';
                  }
                  if (rule.value_mode_id == '2') {
                    return 'Single Value';
                  }
                  if (rule.value_mode_id == '3') {
                    return 'Rule Values by Participant';
                  }
                  if (rule.value_mode_id == '4') {
                    return 'Running Balance Single';
                  }
                  if (rule.value_mode_id == '5') {
                    return 'Running Balance by Participant';
                  }
                  return 'Unknown';
                },
                value: function(rule) {
                  if (rule.value_mode_id != '3' && rule.value_mode_id != '5') {
                    return rule.value;
                  }

                  var values = rule.values.map(function (value) {
                    return parseInt(value.value, 10);
                  });

                  var min = Math.min.apply(this, values);
                  var max = Math.max.apply(this, values);

                  if (min === max) {
                    return max;
                  }

                  return min + ' - ' + max;
                },
                confirmDelete : function(index, event) {
                    var rule = this.rules[index];
                    var html = "<b>Are you sure you want to delete this Rule?</b><br />\n<br />\n";
                    html += "<table>\n";
                    html += '<tr><td><label>Rule ID:</label></td><td>&nbsp;&nbsp;' + rule.id + "</td>\n";
                    html += '<tr><td><label>Rule Name:</label></td><td>&nbsp;&nbsp;' + rule.name + "</td>\n";
                    html += '<tr><td><label>Start Date:</label></td><td>&nbsp;&nbsp;' + rule.start_date + "</td>\n";
                    html += '<tr><td><label>End Date:</label></td><td>&nbsp;&nbsp;' + rule.end_date + "</td>\n";
                    html += "</table>\n";
                    this.confirmDeleteMessage = html;
                    $('#confirmDelete').modal('show');
                    $('#confirmDelete').find('.btn-ok').attr('href', $(event.currentTarget).attr('data-href'));
                }
            }
        });

    </script>
    <script type="text/javascript" src="{{ url('/vendor/ignite/js/rule/testRule.js') }}"></script>
@endsection
