<?php
namespace Ignite\Claim\Emails;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class ClaimEmail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    /** @var array $data */
    public $data;

    /**
     * Create a new message instance.
     *
     * @param array $data
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $settings = (! empty($this->data['email_settings']))
            ? $this->data['email_settings']
            : [];

        $this->to($settings['toEmail']);

        if (! empty($settings['subject'])) {
            $this->subject($settings['subject']);
        }

        if (! empty($settings['from'])) {
            $this->from($settings['from']);
        }

        $this->bcc(config('mail.from.address'), config('mail.from.name'));

        if (! empty($recipients = config('claim.additional_recipients', [])) && is_array($recipients)) {
            foreach ($recipients as $email => $name) {
                $this->bcc($email, $name);
            }
        }

        return $this->markdown($settings['template'])->with('claim', $this->data);
    }
}
