<?php

namespace Ignite\Claim\Exceptions;

class DynamicColumnLoadException extends \Exception
{
    /** @var array */
    protected $messages = [];

    /**
     * DynamicColumnLoadException constructor.
     *
     * @param array $messages
     * @param int $code
     * @param \Throwable|null $previous
     */
    public function __construct($messages = [], $code = 0, \Throwable $previous = null)
    {
        $this->messages = !is_array($messages) ? [$messages] : $messages;

        parent::__construct(implode("\n", $this->messages), $code, $previous);
    }

    /**
     * Get the list of messages.
     *
     * @return array
     */
    public function getMessages()
    {
        return $this->messages;
    }
}
