@extends('Claim::layouts.tables')

@section('page_heading', 'Overview')
@section('page_breadcrumb', 'Overview')

@section('page_content')

<div class="nav-tabs-custom">
    <ul class="nav nav-tabs">
        <li><a href="{{ url('/admin/settings/settings') }}">Settings</a></li>
        <li><a href="{{ url('/admin/settings/forms') }}">Forms</a></li>
        <li class="active"><a href="{{ url('/admin/settings/tables') }}">Tables</a></li>
    </ul>
    <div class="tab-content">
        <a type="button" class="btn btn-default" href="{{ url('/admin/settings/tables/create') }}"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></a>


        <table class="table table-striped table-responsive table-data" id="tablesTable">
            <thead>
                <tr>
                    <th class="text-left" nowrap>&nbsp;</th>
                    <th>Key</th>
                    <th>Table</th>
                    <th>Class</th>
                    <th>Dynamic Columns</th>
                </tr>
            </thead>
            <tbody>
            @forelse($tables as $table)
                <tr>
                    <td class="text-left" nowrap>
                        <a type="button" class="btn btn-sm btn-default" href="{{ url('/admin/settings/tables/edit') . '/' .  $table->key }}" >Edit</a>
                        <button class="btn btn-sm btn-danger" data-href="{{ url('/admin/settings/tables/delete') . '/' . $table->key }}" data-toggle="modal" data-target="#confirmDelete">Delete</button>
                    </td>
                    <td data-name="key">{{ $table->key }}</td>
                    <td data-name="name">{{ $table->name }}</td>
                    <td data-name="fqn">{{ $table->fqn }}</td>
                    <td>{{ (( ! empty($table->dynamic_columns) ) ? implode(',', array_keys($table->dynamic_columns)) : '') }}</td>
                </tr>
                @empty
                <tr>
                    <td colspan="10" class="text-danger text-center">No Tables found.</td>
                </tr>
            @endforelse
            </tbody>
        </table>
    </div>
</div>

<!-- Modal Confirm Dialog -->
<div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="m-0">Delete Table Settings</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete these Table Settings?</p>
                <div class="alert alert-danger">
                    <span class="fa fa-exclamation-triangle"></span> This CANNOT be reversed!
                </div>
                <div class="delete-details" id="table-delete-details"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>
@endsection

@push('js')
<script>
$(document).ready(function(){
    $('#confirmDelete').on('show.bs.modal', function(e) {
        var $row = $(e.relatedTarget).closest('tr');
        var key = $row.find('td[data-name="key"]').html();
        var name = $row.find('td[data-name="name"]').html();
        var fqn = $row.find('td[data-name="fqn"]').html();
        var html = '';
        html += "<table class='table table-bordered table-striped'>\n";
        html += '<tr><td><label>Settings Key:</label></td><td>&nbsp;&nbsp;' + key + "</td>\n";
        html += '<tr><td><label>Table Name:</label></td><td>&nbsp;&nbsp;' + name + "</td>\n";
        html += '<tr><td><label>Class:</label></td><td>&nbsp;&nbsp;' + fqn + "</td>\n";
        html += "</table>\n";
        $('#table-delete-details').html(html);
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
});
</script>
@endpush
