@extends('Core::layouts.main')

@section('meta_title', 'Promotions | Claim Management')

@section('heading')
    <h1>
        Promotions
        <small><a href="{{ url('/admin/claim/list') }}">Claim Management</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="/admin/claim">Claims</a></li>
    <li class="active">Promotions</li>
@endsection

@section('page_content')
    <div class="box box-primary">
        <div class="box-body">
            {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
        </div>
    </div>
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}

    <form class="form-horizontal">
        @if (count($campaigns) > 0)
            <label for="campaignId" class="control-label"><h4>Campaign:&nbsp;</h4></label>
            <select class="form-control col-md-6" size="1" name="campaignId" id="campaignId">
                <option value="0" @if ("$campaignId" == 0)selected="selected"@endif>-- All --</option>
                @foreach($campaigns as $campaign)
                    <option value="{{ $campaign['id'] }}" @if ($campaign['id'] == "$campaignId")selected="selected"@endif>{{ $campaign['name'] }}</option>
                @endforeach
            </select>
        @else
            <input type="hidden" name="campaignId" value="1" />
        @endif
    </form>
    <script>
        $(document).ready(function($) {
            $('#campaignId').change(function() {
                var url = '/admin/claim/promotions/' + $('#campaignId').val();
                document.location = url;
            });
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    enabled: true,
                    text: '<span class="fa fa-bullhorn"></span> <span>Select Campaign</span>',
                    action: function (e, dt, node, conf) {
                        var $node = $(node);
                        $node.addClass('dropdown-toggle').attr('data-toggle', 'dropdown');
                        $node.parent().on('show.bs.dropdown', function () {
                            $node.parent().find('ul.dropdown-menu').remove();
                            var list = $('<ul></ul>', {'class': 'dropdown-menu'});
                            var campaigns = {!! $campaigns->toJson() !!};
                            $.each(campaigns, function(idx, campaign) {
                                var item = $('<li></li>').append($('<a></a>', {
                                    href: '/admin/claim/promotions/' + campaign.id
                                }).text(campaign.name));
                                list.append(item).addClass('in').appendTo($node.parent());
                            });
                        });
                        $node.parent().on('hide.bs.dropdown', function () {
                            $node.parent().find('ul.dropdown-menu').remove();
                        });
                    }
                }]
            });
        });
    </script>
@endsection
