<?php

namespace Ignite\Claim\Http\Controllers\Admin;

use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Models\Grid\TrashedTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Ignite\Claim\Services\Shredder;

class TrashedController extends Controller
{
    /**
     * Show all thrashed claim participant records.
     *
     * @param TrashedTable $table
     * @param Request $request
     *
     * @return \Illuminate\Http\JsonResponse|mixed
     */
    public function index(TrashedTable $table, Request $request)
    {
        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Claim::admin.trashed');
    }

    public function store(Request $request)
    {
        try {
            $ids = explode(',', $request->get('ids', ''));
            $participants = ClaimParticipant::query()
                ->onlyTrashed()
                ->whereIn('id', $ids)
                ->get()
                ->each(function ($participant) {
                    $participant->restore();
                });
            $message = sprintf('%s trashed %s successfully restored.',
                count($ids), str_plural('claim participant', count($ids))
            );
            flash()->success($message)->important();

        } catch (\Exception $e) {
            flash()->error($e->getMessage())->important();
        }

        return redirect()->route('admin.claim.trashed');
    }

    public function destroy(Request $request, Shredder $shredder)
    {
        try {
            $ids = explode(',', $request->get('ids', ''));
            $count = $shredder->destroy($ids);
            $message = sprintf('%s trashed %s successfully deleted.',
                $count, str_plural('claim participant', $count)
            );
            flash()->success($message)->important();

        } catch (\Exception $e) {
            flash()->error($e->getMessage())->important();
        }

        return redirect()->route('admin.claim.trashed');
    }
}
