
$(document).ready(function(){

    $('#testRulesDialog').on('show.bs.modal', function(e) {
        $('#rulesTestResult').html('');
        $('#rulesTestDetails').html('');
    });

    var testFormValidator = $('#ruleTestForm').validate();
});

var testRulesVue = new Vue({

  el: '#testRulesVue',

  data: {
    campaignId: 1,
    claimId : '',

    hideSelectRules : true,
    activeOnly : 1,
    participantType : '',
    debugLevel : 10,

    notSelectedRules: [],
    selectedRules: [],

    ruleIdsList: 'All',
    rulesTestResult: '',
    rulesTestDetails: ''
  },

  mounted: function() {
    this.resetSelectedRules(0);
    this.setRuleOptions();
  },

  methods : {

    resetSelectedRules : function(ruleId) {
      var self = this;

      self.notSelectedRules = [];
      self.selectedRules = [];

      var notSelectedCount = 0;
      var selectedCount = 0;

      for(var ii in allRulesSelect) {
          rule = allRulesSelect[ii];
          if ( rule['id'] == ruleId ) {
              self.selectedRules[selectedCount++] = $.extend(true, {}, rule);
          }
          else {
              self.notSelectedRules[notSelectedCount++] = $.extend(true, {}, rule);
          }
      }
    },

    setRuleOptions : function() {
      self = this;

      $('#rulesSelect').multiselect({
          sort: false,
          moveToRight: function(Multiselect, $options, event, silent, skipStack){
              var moved = [];
              $options.each(function() {
                  var value = $(this).val();
                  var text = $(this).text();
                  self.selectedRules[self.selectedRules.length] = {id:value, name:text};
                  moved[moved.length] = value;

                  var notSelected = [];
                  $.each(self.notSelectedRules, function() {
                      if ( moved.indexOf(this.id.toString()) == -1 ) {
                          notSelected[notSelected.length] = this;
                      }
                  });
                  self.notSelectedRules = notSelected;
              });
              Vue.nextTick(function(){ self.$forceUpdate(); });
              self.updateRuleList();
              return false;
          },
          moveToLeft: function(Multiselect, $options, event, silent, skipStack){
              var moved = [];
              $options.each(function() {
                  var value = $(this).val();
                  var text = $(this).text();
                  self.notSelectedRules[self.notSelectedRules.length] = {id:value, name:text};
                  moved[moved.length] = value;

                  var selected = [];
                  $.each(self.selectedRules, function() {
                      if ( moved.indexOf(this.id.toString()) == -1 ) {
                          selected[selected.length] = this;
                      }
                  });
                  self.selectedRules = selected;
              });
              Vue.nextTick(function(){ self.$forceUpdate(); });
              self.updateRuleList();
              return false;
          },
      });
    },

    setRulesMode : function(mode) {
        if ( mode == '1' ) {
            this.hideSelectRules = true;
            this.resetSelectedRules(0);
            this.updateRuleList();
        }
        else {
            this.hideSelectRules = false;
        }
    },

/*
    showTestDialog : function(ruleId) {
        this.rulesTestResult = '';
        this.rulesTestDetails = '';
        // this.activeOnly = 0;
        // this.debugLevel = 10;
        $('#testRulesDialog').modal('show');
    },
*/

    updateRuleList :function() {
        var html = '';
        $.each(self.selectedRules, function() {
            html += this.id + ' - ' + this.name + "\n";
        });
        if ( html != '' )
            this.ruleIdsList = html;
        else
            this.ruleIdsList = 'All';
    },

    testRules : function() {
        var self = this;

        if ( ! $('#ruleTestForm').valid() )
            return false;

        var token = $('[name=_token]').val();

        var submitData = {};
        submitData._token = token;
        submitData.claimId = self.claimId;
        submitData.participantType = self.participantType;
        submitData.activeOnly = ( self.$data.activeOnly ) ? 1 : 0;
        submitData.debugLevel = self.debugLevel;
        submitData.ruleIds = [];

        $.each(self.selectedRules, function(){
            submitData.ruleIds[submitData.ruleIds.length] = this.id;
        });

        self.$data.rulesTestDetails = '';
        self.$data.rulesTestResult = '';

        axios.post('/admin/rule/api/test', submitData)
            .then(function(response) {
                var values = response.data.data.values;
                var logs = response.data.data.logs;
                var html = '';
                $(logs).each(function() {
                    html += '(' + this.level + ') ' + this.message + "\n";
                });
                self.$data.rulesTestDetails = html;

                var lineCount = 1;
                html = '';
                $.each(values, function(lineKey, lineitem) {
                    if ( lineKey == 'claim_total' ) {
                        html += 'Claim Total = ' + lineitem + "\n";
                    }
                    else {
                        var parts = lineKey.split(' - ');
                        html += 'Line Item: ' + lineCount + ', Offer: ' + parts[1] + "\n";
                        $.each(lineitem, function(ruleKey, value) {
                            if ( ruleKey == 'total' )
                                html += '        Line ' + lineCount + ' Total = ' + value + "\n";
                            else
                                html += '        ' + ruleKey + ', Value: ' + value + "\n";
                        });
                        ++lineCount;
                    }
                });
                self.$data.rulesTestResult = html;
            })
            .catch(function(response) {
                var messages = getResponseErrors(response, 'response.data.errors');
                alert('Unable to Test Rule for Claim Id = ' + self.$data.claimId + "\n" + messages + response.response.status + ': ' + response.response.statusText);
            });
    }

  }

});
