(function($, window, document, undefined) {
    'use strict';

    var dirtyFlag = false;

    $(document).ready(function() {

        function clearAppendedFields() {
            $('.appendedFields').remove();
        }

        $('#review').click(function(e) {
            e.preventDefault();
            var mode = $('#mode').val();

            // Validate the Form Fields before we do all the Appending stuff
            if (! $("#claimForm").valid()) {
                return false;
            }

            // First get rid of any previously appended fields
            clearAppendedFields();

            if (typeof window.documentTypes !== 'undefined' && window.documentTypes.length > 1) {
                if (! window.filesVm.checkRequiredDocuments()) {
                    return false;
                }
            }

            var ii = 0;
            $('#claimItemsList tr.claimItem').each(function() {
                $(this).find('input[type=hidden]').each(function() {
                    var name = $(this).attr('name');
                    var value = $(this).attr('value');
                    var html = '<input type="hidden" class="appendedFields" name="claim_items[' + ii + '][' + name  + ']" value="' + value + '" />';
                    $('#claimForm').append(html);
                });
                ++ii;
            });

            //var ii = 0;
            $('#claimParticipantsList tr.claimParticipant').each(function(idx) {
                $(this).find('input[type=hidden]').each(function() {
                    var name = $(this).attr('name');
                    var value = $(this).attr('value');
                    var html = '<input type="hidden" class="appendedFields" name="claim_participants[' + idx + '][' + name  + ']" value="' + value + '" />';
                    $('#claimForm').append(html);
                });
                //++ii;
            });

            $('body [data-dynamic_table]').each(function() {
                var table = $(this).attr('data-dynamic_table');
                var name = $(this).attr('name');
                var value = $(this).val();
                var html = '<input type="hidden" class="appendedFields" name="dynamicFields[' + table + '][' + name  + ']" value="' + value + '" />';
                $('#claimForm').append(html);
            });

            if (typeof window.documentTypes !== 'undefined' && window.documentTypes.length) {
                var upload = window.filesVm.uploadFiles(false);
                if (! upload) {
                    window.Ignite.Core.flash('File upload failed.', 'error');
                    return false;
                }
                var ii = 0;
                for (var index in window.filesVm.uploadList) {
                    var uploadFile = window.filesVm.uploadList[index];
                    var html  = '';
                    html += '<input type="hidden" class="appendedFields" name="upload_files[' + ii + '][fileId]" value="' + uploadFile.fileId + '" />';
                    html += '<input type="hidden" class="appendedFields" name="upload_files[' + ii + '][documentType]" value="' + uploadFile.documentType + '" />';
                    html += '<input type="hidden" class="appendedFields" name="upload_files[' + ii + '][fileName]" value="' + uploadFile.fileName + '" />';
                    html += '<input type="hidden" class="appendedFields" name="upload_files[' + ii + '][storeFileName]" value="' + uploadFile.storeFileName + '" />';
                    $('#claimForm').append(html);
                    ++ii;
                }
            }

            $(window).off('beforeunload');

            $('#claimForm').trigger('submit');
        });

        var icons = {
          time: "fa fa-clock-o",
            date: "fa fa-calendar",
            up: "fa fa-arrow-up",
            down: "fa fa-arrow-down",
            previous: 'fa fa-chevron-left',
            next: 'fa fa-chevron-right',
            today: 'fa fa-calendar-times-o',
            clear: 'fa fa-trash',
            close: 'fa fa-remove'
        };

        $('.datetimepicker').datetimepicker({
            format: 'MM/DD/YYYY HH:mm:ss',
            icons: icons
        });

        $('.datepicker').datetimepicker({
            format: 'MM/DD/YYYY',
            icons: icons
        });

        $('input, select, textarea').change(function() {
            dirtyFlag = true;
        });

        $(window).on('beforeunload', function() {
            if (dirtyFlag) {
                return "You may have unsaved changes.\nAre you sure you want to leave this page?";
            }
        });

        var claimFormValidator = $('#claimForm').validate(window.validationConfig);
    });
})(window.jQuery, window, document);
