<?php

namespace Ignite\Claim\Database\Seeders;

use Ignite\Core\Database\Seeders\AbstractSeeder;
use Ignite\Claim\Entities\OfferPromotion;

class OfferPromotionsTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        //$offerPromotionRepository = app(OfferPromotionRepository::class);
        $strategy = $this->strategy('json', [
            'filepath' => $this->getFilepath('offer_promotions.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        //OfferPromotion::truncate();

        foreach ($sources as $source) {
            try {
                OfferPromotion::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
