<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimRuleLogTable extends Migration
{
    protected $tableName = 'claim_rule_log';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('claim_participant_id');
            $table->longText('log_text');
            $table->timestamps();
            $table->foreign('claim_participant_id')->references('id')->on('claim_participant')->onDelete('cascade');
            $table->unique(['claim_participant_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
