<?php

/**
 * Convenience function for using Setting Class without adding the use path everywhere
 */
if (! function_exists('setting')) {
    /**
     * Get the settings repository or find a setting by key.
     *
     * @param  string|null $key
     * @param  mixed       $default
     * @param  bool        $boolean
     * @return \Ignite\Claim\Repositories\SettingsRepository|mixed
     */
    function setting($key = null, $default = false, $boolean = false)
    {
        /** @var \Ignite\Claim\Repositories\SettingsRepository $repository */
        $repository = app(\Ignite\Claim\Repositories\SettingsRepository::class);

        if (! is_null($key)) {
            $value = $repository->find((string) $key, $default);
            return ($boolean) ? (bool) $value : $value;
        }

        return $repository;
    }
}
