<?php

namespace Ignite\Claim\Database;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

abstract class IgniteMigration extends Migration
{
    /**
     * The global session values.
     * @var string
     */
    protected $sqlModeGlobal  = '';

    /**
     * The current session values.
     * @var string
     */
    protected $sqlModeSession = '';

    /**
     * Update the MySQL session settings and save the original to a class property.
     */
    public function __construct()
    {
        // Get and save the current MySQL Database Global and Session settings
        $result = DB::select(DB::raw('SELECT @@GLOBAL.sql_mode global, @@SESSION.sql_mode session'));
        $sqlModes = $result[0];

        $this->sqlModeGlobal  = $sqlModes->global;
        $this->sqlModeSession = $sqlModes->session;

        // Remove the STRICT_TRANS_TABLES and NO_ZERO_IN_DATE settings
        $sqlTempSession = str_replace('STRICT_TRANS_TABLES,', '', $this->sqlModeSession);
        $sqlTempSession = str_replace('NO_ZERO_DATE,', '', $sqlTempSession);
        $sqlTempSession = str_replace('NO_ZERO_IN_DATE,', '', $sqlTempSession);

        // Update the MySQL Session settings
        DB::select(DB::raw("SET sql_mode = '$sqlTempSession'"));
    }

    /**
     * Restore the original MySQL Session settings.
     */
    public function __destruct()
    {
        DB::select(DB::raw(sprintf("SET sql_mode = '%s'", $this->sqlModeSession)));
    }

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }

    /**
     * @todo Ed, This doesnt filter by foreign key? Do we still need this
     * @param  string $foreignKey
     * @return bool
     */
    public function hasForeignKey($foreignKey)
    {
        $sql = "SELECT *
        FROM information_schema.table_constraints
        WHERE
        TABLE_SCHEMA = 'ignite3'
        AND TABLE_NAME = 'claim'
        AND CONSTRAINT_TYPE = 'FOREIGN KEY'";

        $result = DB::select(DB::raw($sql));

        if (count($result) > 0) {
            return true;
        }

        return false;
    }
}
