<?php

namespace Ignite\Claim\Models\Audit;

use Ignite\Claim\Entities\Claim;
use Ignite\Claim\Entities\ClaimLineItem;
use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Entities\File;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Contracts\Audit;
use OwenIt\Auditing\Drivers\Database;
use OwenIt\Auditing\Models\Audit as AuditModel;

class ClaimDriver extends Database implements AuditDriver
{
    /**
     * @inheritDoc
     */
    public function audit(Auditable $model): Audit
    {
        $class = config('audit.implementation', AuditModel::class);

        $audit = $model->toAudit();
        $audit['context_type'] = Claim::class;
        $audit['context_id'] = $this->getContextId($model);

        if ($model instanceof File && $model->related_name === 'claim') {
            $audit['context_id'] = $model->related_id;
        }

        return $class::create($audit);
    }

    /**
     * Determine the context id based on model type.
     *
     * @param  Auditable $model
     * @return mixed
     */
    private function getContextId(Auditable $model)
    {
        if ($model instanceof Claim) {
            return $model->getKey();
        }

        if ($model instanceof ClaimLineItem || $model instanceof ClaimParticipant) {
            return $model->getAttribute('claim_id');
        }

        return null;
    }
}
