<?php

namespace Ignite\Claim\Http\Controllers\Api;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Claim\Entities\Dynamic\IgniteDB;
use Ignite\Claim\Entities\Dynamic\DynamicModel;
use Ignite\Claim\Entities\Setting;
use Ignite\Claim\Entities\Table;

class TableColumnsController extends Controller
{
    public function store()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result   = true;
        $response->messages = [];
        $response->data     = false;

        $tableId = isset($data['tableColumns']['id']) ? $data['tableColumns']['id'] : 'new';
        $tableKey = $data['tableColumns']['key'];
        $tableFqn = $data['tableColumns']['fqn'];
        $tableName = $data['tableColumns']['name'];
        $tableStatic = $data['tableColumns']['static_columns'];
        $tableDynamic = isset($data['tableColumns']['dynamic_columns']) ? $data['tableColumns']['dynamic_columns'] : [];

        try {
            $table = $tableId == 'new' ? new Table() : Table::where('id', $tableId)->first();
            $table->key = $tableKey;
            $table->fqn = $tableFqn;
            $table->name = $tableName;
            $table->static_columns = $tableStatic;
            $table->dynamic_columns = $tableDynamic;
            $table->save();
        } catch (\Exception $e) {
            $response->result   = false;
            $response->messages[] = $e->getMessage();
        }

        $httpCode = ($response->result) ? 200 : 422;
        return response(json_encode($response), $httpCode);
    }

    public function syncDbColumns()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result   = true;
        $response->messages = [];
        $response->data     = false;

        $tableId = $data['tableId'];
        $tableKey = $data['tableKey'];
        $tableName = $data['tableName'];

        try {
            $class = DynamicModel::$tables[$tableName]['class'];
            $table = new $class();

            $tableModel = Table::findByKey($tableKey);

            $infos = [];
            $tableModel = $this->syncNativeColumns($tableModel, $table, $infos);
            $tableModel->save();

            $message = sprintf("Database Columns sync'd for table '%s':", $tableName);
            array_unshift($infos, $message);
            $this->flash('info', $infos);
        } catch (\Exception $e) {
            $response->result   = false;
            $response->messages[] = $e->getMessage();
        }

        return response()->json($response, ($response->result) ? 200 : 422);
    }

    private function syncNativeColumns($tableModel, $table, &$infos = [])
    {
        $infos = [];

        if (! empty($table->isDynamicModel)) {
            // If the Table is a Dynamic Table, we can get all the Database info from it
            $IgniteDb = $table->getLocal('IgniteDb');
            $databaseName = $table->getLocal('databaseName');
            $tableName = $table->getLocal('tableName');
        } else {
            // If NOT a Dynamic Table, we have to get the Database info Directly
            $IgniteDb = IgniteDB::create();
            $databaseName = IgniteDB::get('databaseName');
            $tableName = $table->getTable();
        }

        $nativeColumns = $IgniteDb->getColumns($databaseName, $tableName);
        $dbColumns = $tableModel->static_columns;
        $updatedColumns = (array) $dbColumns;

        foreach ($dbColumns as $name => $column) {
            if (! isset($nativeColumns[$name])) {
                unset($updatedColumns[$name]);
                $infos[] = sprintf("Settings Column '%s' missing on Database, Column Removed.", $name);
            }
        }

        foreach ($nativeColumns as $name => $column) {
            if (! isset($dbColumns->$name)) {
                $IgniteDb = $table->getLocal('IgniteDb');
                $updatedColumns[$name] = $IgniteDb->convertColumnToDb($column);
                $infos[] = sprintf("Database Column '%s' missing on Settings, Column Added.", $name);
            }
        }

        $tableModel->static_columns = $updatedColumns;

        return $tableModel;
    }
}
