@extends('Claim::layouts.forms')

@section('page_heading', 'Forms')
@section('page_breadcrumb', 'Forms')

@section('page_content')

    <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
            <li><a href="{{ url('/admin/settings/settings') }}">Settings</a></li>
            <li class="active"><a href="{{ url('/admin/settings/forms') }}">Forms</a></li>
            <li><a href="{{ url('/admin/settings/tables') }}">Tables</a></li>
        </ul>
        <div class="tab-content">
            <a type="button" class="btn btn-default" href="{{ url('/admin/settings/forms/create') }}"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></a>

            <table class="table table-striped table-responsive data-table" id="formsTable">
                <thead>
                    <tr>
                        <th>&nbsp;</th>
                        <th>Key</th>
                        <th>Form</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($forms as $form)
                        <tr>
                            <td align="left" nowrap>
                                <a type="button" class="btn btn-sm btn-default" href="{{ url('/admin/settings/forms/edit') . '/' .  $form->key }}" >Edit</a>
                                <button class="btn btn-sm btn-danger" data-href="{{ url('/admin/settings/forms/delete') . '/' . $form->key }}" data-toggle="modal" data-target="#confirmDelete">Delete</button>
                            </td>
                            <td data-name="key">{{ $form->key }}</td>
                            <td data-name="name">{{ $form->name }}</td>
                        </tr>
                    @empty
                    <tr>
                        <td colspan="10" class="text-danger text-center">No forms found.</td>
                    </tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Modal Confirm Dialog -->
    <div class="modal fade" id="confirmDelete" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger">
                    <h3>Delete Form</h3>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Form?<br />
                    <br />
                    This CANNOT be reversed.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-danger btn-ok">Delete</a>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
<script>
$(document).ready(function(){
    $('#confirmDelete').on('show.bs.modal', function(e) {
        var $row = $(e.relatedTarget).closest('tr');
        var key = $row.find('td[data-name="key"]').html();
        var formName = $row.find('td[data-name="name"]').html();
        var html = "<b>Are you sure you want to delete these Table Settings?</b><br />\n<br />\n";
        html += "<table>\n";
        html += '<tr><td><label>Settings Key:</label></td><td>&nbsp;&nbsp;' + key + "</td>\n";
        html += '<tr><td><label>Form Name:</label></td><td>&nbsp;&nbsp;' + formName + "</td>\n";
        html += "</table>\n";
        $('#confirmDelete .modal-body').html(html);
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
});
</script>
@endpush
