<?php

namespace Ignite\Claim\Providers;

use Ignite\Claim\Events\ClaimEvent;
use Ignite\Claim\Events\Handlers\LinkWaitingClaims;
use Ignite\Claim\Events\Handlers\Menus\AddClaimToParticipantActionMenu;
use Ignite\Claim\Events\Handlers\Menus\AddClaimItemsToNavigationMenu;
use Ignite\Claim\Events\Handlers\Menus\AddClaimToParticipantPanel;
use Ignite\Claim\Events\Handlers\Menus\AddClaimMenu;
use Ignite\Claim\Events\Handlers\ClaimEventHandler;
use Ignite\Claim\Events\Handlers\Participants\DeleteClaimRelationsWhenDeletingParticipant;
use Ignite\Core\Events\EnrollmentDeleting;
use Ignite\Core\Events\EnrollmentSubmitted;
use Ignite\Core\Events\Menus\ActionMenuPreCompile;
use Ignite\Core\Events\Menus\AdminMenuPreCompile;
use Ignite\Core\Events\Menus\NavigationMenuPreCompile;
use Ignite\Core\Events\Menus\ParticipantMenuPreCompile;
use Ignite\Core\Events\Menus\UserMenuPreCompile;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    public function boot()
    {
        parent::boot();
    }

    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        NavigationMenuPreCompile::class => [
            AddClaimItemsToNavigationMenu::class
        ],
        UserMenuPreCompile::class => [
            AddClaimItemsToNavigationMenu::class
        ],
        AdminMenuPreCompile::class => [
            AddClaimMenu::class
        ],
        ParticipantMenuPreCompile::class => [
            AddClaimToParticipantPanel::class
        ],
        ActionMenuPreCompile::class => [
            AddClaimToParticipantActionMenu::class
        ],
        EnrollmentDeleting::class => [
            DeleteClaimRelationsWhenDeletingParticipant::class
        ],
        EnrollmentSubmitted::class => [
            LinkWaitingClaims::class
        ],
        ClaimEvent::class => [
            \Ignite\Claim\Events\Handlers\ClaimEventHandler::class
        ]
    ];

    /**
     * The subscriber classes to register.
     *
     * @var array
     */
    protected $subscribe = [];
}
