<?php

namespace Ignite\Claim\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Ignite\Flash\Facades\Flash;
use Illuminate\Http\Request;
use Ignite\Claim\Models\Status;
use Ignite\Claim\Models\Grid\IssueTable;

class IssueController extends Controller
{
    /**
     * Display a list of pending claims in need of processing.
     *
     * @param IssueTable $table
     * @param Request    $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\Response
     */
    public function index(IssueTable $table, Request $request)
    {
        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Claim::admin.issue.index');
    }

    /**
     * Update the status for the provided claim ids.
     *
     * @param Request $request
     * @param Status  $helper
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Request $request, Status $helper)
    {
        $data = $request->validate([
            'items' => 'required',
            'status' => 'required', // should be issued
        ]);

        $ids = explode(',', $data['items']);
        $passed = $failed = 0;

        // Loop through each claim participant and send them an email notification.
        foreach ($ids as $id) {
            try {
                $response = $helper->setStatus((int) $id, $data);
                if ($response->result) {
                    ++$passed;
                    $helper->flashMessage(count($ids), $passed, $failed, $data['status']);
                } else {
                    Flash::error(implode(',', $response->errors));
                }
            } catch (\Exception $e) {
                Flash::error(sprintf(
                    'Error: %s in %s on line %s',
                    $e->getMessage(),
                    $e->getFile(),
                    $e->getLine()
                ));
                logger($e->getMessage());
                ++$failed;
            }
        }

        return redirect()->back();
    }
}
