<?php

namespace Ignite\Claim\Database\Seeders;

use Ignite\Claim\Entities\Translation;
use Ignite\Core\Database\Seeders\AbstractSeeder;

class TranslationTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        /* TODO: Create a repository class for Settings
        $settingRepository = app(PageRepository::class); */
        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/translations.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Translation::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
