<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddOfferToClaimLineitem extends Migration
{
    protected $tableName = 'claim_lineitem';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->unsignedInteger('offer_id');
            $table->foreign('offer_id')->references('id')->on('claim_offer');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table($this->tableName, function (Blueprint $table) {
            $table->dropForeign('claim_lineitem_offer_id_foreign');
            $table->dropColumn('offer_id');
        });
    }
}
