<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimRuleConditionTable extends Migration
{
    protected $tableName = 'claim_rule_condition';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('rule_id');
            $table->integer('order')->nullable();
            $table->string('db_column', 255);
            $table->text('data_1');
            $table->text('data_2')->nullable();
            $table->string('directive', 255);
            $table->foreign('rule_id')->references('id')->on('claim_rule');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
