<?php

namespace Ignite\Claim\Traits;

use Ignite\Claim\Entities\Claim;
use Ignite\Claim\Entities\ClaimParticipant;
use Ignite\Claim\Entities\File;
use Ignite\Claim\Entities\OfferUserPromotionGroup;

trait ClaimRelations
{
    /**
     * The relationship to claim participant records.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function claimParticipants()
    {
        return $this->hasMany(ClaimParticipant::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to claims.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function claims()
    {
        return $this->hasMany(Claim::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to claims.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function files()
    {
        return $this->hasMany(File::class, 'user_id', 'user_id');
    }

    /**
     * The relationship to offer promotion groups.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function offerPromotionGroups()
    {
        return $this->hasMany(OfferUserPromotionGroup::class, 'user_id', 'user_id');
    }
}
