<?php

Route::group([
    'middleware' => ['web', 'auth'],
], function () {

    // Participant Table
    Route::group(['prefix' => '/admin/participant'], function () {
        Route::any('/participants/{participant}/claims/{status?}', 'Admin\ParticipantClaimsController@index')->name('admin.participant.claims');
    });

    // Claim Admin Pages Routes
    Route::group(['prefix' => '/admin/claim'], function () {
        Route::any('/trashed', 'Admin\TrashedController@index')->name('admin.claim.trashed');
        Route::any('/trashed/export', 'Admin\TrashedController@index')->name('admin.claim.trashed.export');
        Route::put('/trashed/restore', 'Admin\TrashedController@store')->name('admin.claim.restore');
        Route::delete('/trashed/shred', 'Admin\TrashedController@destroy')->name('admin.claim.shred');

        Route::any('/', 'Admin\ClaimController@index')->name('admin.claim');
        Route::any('/export', 'Admin\ClaimController@index')->name('admin.claim.export');
        Route::any('/index', 'Admin\ClaimController@index');

        Route::any('/list/{type?}/export', 'Admin\ClaimController@list')->name('admin.claim.list.export');
        Route::any('/list/{type?}/{userId?}', 'Admin\ClaimController@list')->name('admin.claim.list');
        Route::any('/process', 'Admin\ProcessController@index')->name('admin.claim.process');
        Route::any('/process/export', 'Admin\ProcessController@index')->name('admin.claim.process.export');
        Route::post('/process/update', 'Admin\ProcessController@update')->name('admin.claim.process.update');
        Route::any('/issue', 'Admin\IssueController@index')->name('admin.claim.issue');
        Route::any('/issue/export', 'Admin\IssueController@index')->name('admin.claim.issue.export');
        Route::post('/issue/update', 'Admin\IssueController@update')->name('admin.claim.issue.update');
        Route::get('/quickview/{claimParticipant}/{claim}', 'Admin\QuickviewController@show')->name('admin.claim.quickview');
        Route::any('/promotions/{campaignId?}', 'Admin\PromotionsController@index')->name('admin.claim.promotions');
        Route::get('/new/{promotionId?}/{code?}', 'Admin\ClaimController@create')->name('admin.claim.create');
        Route::get('/edit/{claimId}/{claimParticipantId}/{code?}', 'Admin\ClaimController@edit')->name('admin.claim.edit');
        Route::get('/view/{claimId}/{claimParticipantId}', 'Admin\ClaimController@show')->name('admin.claim.show');
        Route::get('/testapprove/{claimId}/{claimParticipantId}', 'Admin\ClaimController@testApprove');

        Route::post('/review', 'Admin\ClaimController@review')->name('admin.claim.review');
        Route::post('/store', 'Admin\ClaimController@store')->name('admin.claim.store');
        Route::post('/addnote', 'Admin\ClaimController@addNote')->name('admin.claim.note.create');
        Route::get('/delete/{claimId}/{claimParticipantId?}', 'Admin\ClaimController@deleteClaim')->name('admin.claim.destroy');
    });

    // Claim Admin API Routes
    Route::group(['prefix' => '/admin/claim/api'], function () {
        Route::post('/claimparticipant', 'ClaimAdminApiController@claimParticipantGet')->name('api.claim.claimparticipant');
        //Route::post('/setstatus', 'ClaimAdminApiController@setStatus');
    });
});

// Claim Pages Routes
Route::group([
    'middleware' => ['web', 'auth'],
    'prefix' => '/claim'
], function () {
    Route::get('/', 'ClaimController@index')->name('claim.index');
    Route::get('/promotions/{campaignId?}', 'ClaimController@listPromotions')->name('claim.promotions');
    Route::get('/new/{promotionId?}/{code?}', 'ClaimController@create')->name('claim.create');
    Route::post('/review', 'ClaimController@review')->name('claim.review');
    Route::post('/store', 'ClaimController@store')->name('claim.store');
});

// Offer Pages Routes
Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Admin',
    'prefix' => '/admin/offer'
], function () {
    Route::get('/offers/{promotionId?}/{campaignId?}', 'OfferController@showOffers')->name('admin.offer.offers');
    Route::get('/offers', 'OfferController@index')->name('admin.offer.index');
    Route::get('/offers/index', 'OfferController@index');
    Route::get('/campaigns', 'OfferController@showCampaigns')->name('admin.offer.campaigns');
    Route::get('/promotions/{campaignId?}', 'OfferController@showPromotions')->name('admin.offer.show');
    Route::get('/promotiongroups', 'OfferController@showPromotionGroups')->name('admin.offer.promotiongroups.index');
    Route::get('/userpromotiongroups', 'OfferController@showUserPromotionGroups')->name('admin.offer.userpromotiongroups');
});

// ----------------------
// Offers API Routes
// ----------------------
Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Api',
    'prefix' => '/offer/api'
], function () {
    Route::group(['prefix' => '/campaign'], function () {
        Route::get('/get/{campaignId}', 'OfferController@campaignGet');
        Route::post('/store', 'OfferController@campaignStore');
        Route::post('/delete', 'OfferController@campaignDelete');
    });

    Route::group(['prefix' => '/promotion'], function () {
        Route::get('/get/{promotionId}', 'OfferController@promotionGet');
        Route::get('/forcampaign/{campaignId}', 'OfferController@promotionGetForCampaign');
        Route::post('/store', 'OfferController@promotionStore');
        Route::post('/delete', 'OfferController@promotionDelete');
    });

    Route::group(['prefix' => '/promotiongroup'], function () {
        Route::get('/get/{promotionGroupId}', 'OfferController@promotionGroupGet');
        Route::get('/usergroups/{userId}', 'OfferController@promotionGroupGetForUser');
        Route::post('/store', 'OfferController@promotionGroupStore');
        Route::post('/usergroupsstore', 'OfferController@promotionGroupStoreForUser');
        Route::post('/delete', 'OfferController@promotionGroupDelete');
    });

    Route::group(['prefix' => '/offer'], function () {
        Route::get('/get/{offerId}', 'OfferController@offerGet');
        Route::post('/store', 'OfferController@offerStore');
        Route::post('/delete', 'OfferController@offerDelete');
    });
});

Route::group([
    'middleware' => 'web'
], function () {
    // -----------------------------
    // Admin Page Routes
    // -----------------------------
    Route::group(['prefix' => '/admin/rule'], function () {
        Route::get('/promotions/{campaignId?}', 'RuleAdminController@index')->name('admin.rule.promotions.index');
        Route::get('/rules/{promotionId?}', 'RuleAdminController@listRules');
        Route::get('/edit/{ruleId}/{promotionId?}/{code?}', 'RuleAdminController@showEdit');
        Route::get('/delete/{ruleId}/{promotionId?}', 'RuleAdminController@deleteRule');

        Route::post('/store', 'RuleAdminController@storeRule');
    });

    // -----------------------------
    // Admin API Routes
    // -----------------------------
    Route::group(['prefix' => '/admin/rule/api'], function () {
        Route::post('/test', 'RuleAdminApiController@testRule');
    });
});

// ----------------------------------------------
// File Controller Non-Authenticated Routes
// ----------------------------------------------
Route::group([
    'middleware' => 'web',
    'prefix' => '/file',
], function () {
    Route::get('/get/{fileId}', 'FileController@show');
    Route::get('/download/{fileId}', 'FileController@show');
});

// ----------------------------------------------
// File Controller Authenticated Routes
// ----------------------------------------------
Route::group([
    'middleware' => ['web','auth'],
    'prefix' => '/file'
], function () {
    Route::post('/store', 'FileController@store');
    Route::post('/delete', 'FileController@delete');
});

Route::group([
    'middleware' => ['web', 'auth'],
    'namespace' => 'Admin',
    'prefix' => '/admin'
], function () {
    // Settings Pages Routes
    Route::group(['prefix' => '/settings/settings'], function () {
        Route::get('/', 'SettingsController@index')->name('admin.settings.index');
        Route::get('/settings', 'SettingsController@index');
    });

    // Table Pages Routes
    Route::group(['prefix' => '/settings/tables'], function () {
        Route::get('/', 'TableColumnsController@index')->name('admin.settings.tables');
        Route::get('/create', 'TableColumnsController@create');
        Route::get('/edit/{tableName?}', 'TableColumnsController@edit');
        Route::get('/delete/{tableName?}', 'TableColumnsController@delete');
    });

    // Form Pages Routes
    Route::group(['prefix' => '/settings/forms'], function () {
        Route::get('/', 'FormsController@index')->name('admin.settings.forms');
        Route::get('/create', 'FormsController@create');
        Route::get('/edit/{formKey?}', 'FormsController@edit');
        Route::get('/delete/{formKey?}', 'FormsController@delete');
    });
});

// Settings, Forms & Tables API Routes
Route::group([
    'prefix' => '/admin',
    'namespace' => 'Api',
    'middleware' => ['web', 'auth'],
], function () {

    // ----------------------
    // Settings API Routes
    // ----------------------
    Route::group([
        'prefix' => '/settings/api',
    ], function () {
        Route::get('/get/{groupId}', 'SettingsController@get');
        Route::post('/store', 'SettingsController@store');
        Route::post('/delete', 'SettingsController@delete');
    });

    // ----------------------
    // Table Pages API Routes
    // ----------------------
    Route::group([
        'prefix' => '/settings/tables/api',
    ], function () {
        Route::post('/store', 'TableColumnsController@store');
        Route::post('/syncdbcolumns', 'TableColumnsController@syncDbColumns');
    });

    // ----------------------
    // Form Pages API Routes
    // ----------------------
    Route::group([
        'prefix' => '/settings/forms/api'
    ], function () {
        Route::post('/store', 'FormsController@store');
    });
});
