<?php

namespace Ignite\Claim\Events\Handlers\Menus;

use Ignite\Core\Events\Menus\ParticipantMenuPreCompile;
use Nwidart\Modules\Laravel\LaravelFileRepository as ModuleRepository;

class AddClaimToParticipantPanel
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * AddCatalogItemsToNavigationMenu constructor.
     *
     * @param ModuleRepository $moduleRepository
     */
    public function __construct(ModuleRepository $moduleRepository)
    {
        $this->moduleRepository = $moduleRepository;
    }

    /**
     * Handle the event.
     *
     * @param ParticipantMenuPreCompile $event
     */
    public function handle(ParticipantMenuPreCompile $event)
    {
        if ($this->moduleRepository->disabled('Claim')) {
            return;
        }

        $event->getManager()->merge(
            $event->getManager()->hydrateItems(
                $this->getItems($event->getParticipantId())
            )
        );
    }

    /**
     * Get the items to merge with the menu.
     *
     * @param  int $participantId
     * @return \Illuminate\Support\Collection
     */
    protected function getItems($participantId)
    {
        return collect([
            [
                'position' => 11,
                'url' => route('admin.participant.claims', ['participant' => $participantId, 'status' => request()->get('status', 'all')]),
                'label' => 'Claims',
                'icon' => 'gift',
                'allow' => auth()->user()->can('core.user.claims.browse'),
                'badge' => $this->countClaims($participantId)
            ]
        ]);
    }

    /**
     * Count the number of claim entries for the participant.
     *
     * @param  int $participantId
     * @return array
     */
    protected function countClaims($participantId)
    {
        return app(\Ignite\Claim\Entities\ClaimParticipant::class)
            ->query()
            ->where('user_id', $participantId)
            ->count();
    }
}
