<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;

class Form extends Model
{
    /** @var string */
    protected $table = 'claim_form';

    /** @var string */
    protected $primaryKey  = 'id';

    /** @var array */
    protected $casts = [
        'columns' => 'json',
    ];

    /** @var array */
    protected $fillable = [
        'key', 'module', 'type', 'name', 'columns'
    ];

    /** @var null|\Illuminate\Database\Eloquent\Collection */
    protected static $cache;

    /**
     * Find a table record by key.
     *
     * @param  string $key
     * @return \Ignite\Claim\Entities\Form|array
     */
    public static function findByKey($key)
    {
        if (is_null(static::$cache)) {
            static::$cache = static::all()->keyBy('key');
        }

        return static::$cache->get($key, null);
    }
}
