<?php

namespace Ignite\Claim\Models\Legacy;

use Illuminate\Support\Fluent;

class TableConfig extends Fluent
{
    /**
     * The attributes that can be loaded into the class via the constructor.
     *
     * @var array
     */
    protected $fillable = [
        "name",
        "null",
        "type",
        "format",
        "required",
        "validate",
        "sensitive",
        "reportName",
        "displayName",
        "validateType",
    ];

    /**
     * TableConfig
     *
     * @param array $attributes
     */
    public function __construct($attributes = [])
    {
        foreach ($attributes as $attribute => $value) {
            if (! in_array($attribute, $this->fillable)) {
                unset($attributes[$attribute]);
            }
        }

        parent::__construct($attributes);
    }

    /**
     * Determine whether the column is required.
     *
     * @return bool
     */
    public function isRequired()
    {
        return (bool) $this->get('required', '0');
    }

    /**
     * Determine whether the column is sensitive.
     *
     * @return bool
     */
    public function isSensitive()
    {
        return (bool) $this->get('sensitive', '0');
    }

    /**
     * Determine whether the column is nullable.
     *
     * @return bool
     */
    public function isNullable()
    {
        return (bool) $this->get('null', '0');
    }
}
