<?php

namespace Ignite\Claim\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Core\Contracts\Table;
use Ignite\Core\Models\Grid\AbstractTable;
use Ignite\Claim\Traits\SupportFormSchema;
use Ignite\Claim\Traits\SupportTableSchema;
use Yajra\DataTables\DataTables;

abstract class AbstractClaimTable extends AbstractTable implements Table
{
    use SupportTableSchema, SupportFormSchema;

    /**
     * @var DatabaseManager
     */
    protected $database;

    /**
     * AbstractClaimTable constructor.
     *
     * @param DataTables $datatables
     * @param DatabaseManager $databaseManager
     * @param array $params
     */
    public function __construct(DataTables $datatables, DatabaseManager $databaseManager, array $params = [])
    {
        parent::__construct($datatables, $params);
        $this->database = $databaseManager;
    }

    /**
     * Get the database connection for a query engine report.
     *
     * @return \Illuminate\Database\Connection
     */
    protected function getConnection()
    {
        return $this->database->connection();
    }

    /**
     * Get the datatable instance.
     *
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable()
    {
        return $this->_dataTable($this->datatables->query($this->query()));
    }

    /**
     * Attempt to merge any form label information if form information exists.
     *
     * @return array
     */
    protected function getColumns()
    {
        // Get the columns for the report instance.
        $columns = $this->columns();

        // Decorate the report with table schema information and obscure any sensitive data.
        if (property_exists($this, 'decorateTableSchema') || $this->decorateTableSchema === true) {
            $columns = $this->decorateTableSchema($columns);
        }

        if (property_exists($this, 'forms') && !empty($this->forms)) {

            // Use the existing table schema to find any columns marked as storing sensitive data.
            $sensitive = $this->getTableColumns()->where('sensitive', "1")->toArray();

            // Decorate the report with form schema information and obscure any sensitive data.
            $columns = $this->decorateFormSchema($columns, $sensitive);
        }

        return $columns;
    }
}
