<?php

namespace Ignite\Claim\Http\Controllers\Api;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Claim\Entities\Form;

class FormsController extends Controller
{
    /**
     * Store the form data.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store()
    {
        $response = new \stdClass;
        $response->result = true;
        $response->messages = [];
        $response->data = false;

        $data = request()->all();

        try {
            $form = $data['id'] == 'new' ? new Form : Form::find($data['id']);
            $form->key = $data['key'];
            $form->columns = isset($data['columns']) ? $data['columns'] : [];
            $form->save();
        } catch (\Exception $e) {
            $response->result   = false;
            $response->messages[] = $e->getMessage();
        }

        return response()->json($response, $response->result ? 200 : 422);
    }
}
