<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimRuleTable extends Migration
{
    protected $tableName = 'claim_rule';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('offer_promotion_id');
            $table->string('name', 255);
            $table->integer('order');
            $table->integer('value_mode_id');
            $table->integer('value_type_id');
            $table->double('value')->default(0);
            $table->double('max_times')->default(0);
            $table->integer('participants_mode_id');
            $table->integer('offers_mode_id');
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->integer('status')->default(0);
            $table->timestamps();
            $table->foreign('offer_promotion_id')->references('id')->on('claim_offer_promotion');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
