<?php

namespace Ignite\Claim\Models\Options;

use Ignite\Core\Contracts\Source;

class DeclineReasons implements Source
{
    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        $reasons = config('claim.decline.reasons', []);
        $dropdown = [];

        if (empty($reasons)) {
            return $dropdown;
        }

        $emptyReason = config('claim.decline.empty');
        if ($emptyReason) {
            $dropdown[''] = $emptyReason;
        }

        foreach ($reasons as $key => $value) {
            if ($key === '' || $value === '') {
                continue;
            }

            if (is_int($key)) {
                $key = $value;
            }

            $dropdown[$key] = $value;
        }

        return $dropdown;
    }
}
