<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimLineitemTable extends Migration
{
    protected $tableName = 'claim_lineitem';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('claim_id');
            $table->string('name')->default('');
            $table->unsignedInteger('status')->default(0);
            $table->unsignedInteger('qty')->default(1);
            $table->double('value_base')->nullable()->default(null);
            $table->double('multiplier')->nullable()->default(null);
            $table->double('value')->nullable()->default(null);
            $table->string('offer_group')->nullable()->default(null);
            $table->foreign('claim_id')->references('id')->on('claim')->onDelete('cascade');
            $table->softDeletes('deleted_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
