@extends('Claim::admin.rules.layouts.master')

@section('page_heading', 'Promotions')

@section('breadcrumb')
    @parent
    <li class="active">Promotions</li>
@endsection

@section('page_content')
    <div class="box box-primary">
        <div class="box-body">
            @if(count($campaigns) > 1)
                <span class="clearfix">
                    <div class="input-group pull-right" style="max-width: 240px;">
                        <label for="campaignId" class="input-group-addon">Campaign:&nbsp;</label>
                        <select class="form-control select2" style="min-width: 150px; width: auto; display: inline-block;" name="campaignId" id="campaignId">
                            @foreach($campaigns as $campaign)
                                <option value="{{ $campaign['id'] }}" @if ($campaign['id'] == "$campaignId")selected="selected"@endif>{{ $campaign['name'] }}</option>
                            @endforeach
                        </select>
                    </div>
                </span>
                <hr />
            @else
                <input type="hidden" name="campaignId" value="1" />
            @endif
            <table class="table table-bordered table-striped dataTable no-footer">
                <thead class="thead-default">
                <tr>
                    <th>&nbsp;</th>
                    <th>#</th>
                    <th>Name</th>
                    <th>Descripton</th>
                    <th>Start Date</th>
                    <th>End Date</th>
                    <th>Status</th>
                </tr>
                </thead>
                <tbody>
                @if (count($promotions) > 0 )
                    @foreach($promotions as $promotion)
                        <tr data-promotion_id="{{ $promotion['id'] }}">
                            <td>
                                <a type="button" class="btn btn-sm btn-default" data-toggle="modal" href="{{ url('/admin/rule/rules') . '/' . $promotion['id'] }}">Edit Rules</a>
                            </td>
                            <td>{{ $promotion['id'] }}</td>
                            <td>{{ $promotion['name'] }}</td>
                            <td>{{ $promotion['description'] }}</td>
                            <td>{{ Format::date($promotion['start_date']) }}</td>
                            <td>{{ Format::date($promotion['end_date']) }}</td>
                            <td>{{ ($promotion['status'] == 1) ? 'Active' : 'Inactive' }}</td>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <td colspan="10" class="text-center text-danger">No promotions defined.</td>
                    </tr>
                @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('js')
    @parent

    <script>

        $(document).ready(function() {
            $('#campaignId').change(function() {
                var campaignId = $('#campaignId').val();
                var url = '/admin/rule/promotions/' + campaignId;
                window.location.replace(url);
            });
        });

    </script>

@endsection
