<?php

namespace Ignite\Claim\Models\Grid;

use Ignite\Claim\Entities\ClaimParticipant;

class IssueTable extends ProcessTable
{
    /**
     * The table query.
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Query\Builder|\Illuminate\Support\Collection
     */
    public function query()
    {
        return $this->applyScopes(
            ClaimParticipant::with(['participant', 'claim'])
                ->where('claim_participant.status', 'approved')
        );
    }

    /**
     * The columns to display.
     *
     * @return array
     */
    public function columns()
    {
        return $this->replaceColumn(parent::columns(), [
            'date_approved' => [
                'title' => 'Date Approved',
                'name' => 'claim_participant.date_approved',
                'searchable' => true,
                'orderable' => true,
                'exportable' => true,
                'printable' => true,
            ]
        ], 'date_submitted');
    }
}
