<?php

namespace Ignite\Claim\Http\Controllers\Api;

use Ignite\Core\Http\Controllers\Controller;
use Ignite\Claim\Entities\Setting;

class SettingsController extends Controller
{
    public function get($settingId)
    {
        $response = new \stdClass;
        $response->result = true;
        $response->messages = [];
        $response->data = false;

        try {
            $response->data = Setting::find($settingId);
        } catch (\Exception $e) {
            $response->result = false;
            $response->data = false;
            $response->messages[] = $e->getMessage();
        }

        return response()->json($response, $response->result ? 200 : 422);
    }

    public function store()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result = true;
        $response->messages = [];
        $response->data = false;

        try {
            if ($data['id'] == 'new') {
                $setting = new Setting;
            } else {
                $setting = Setting::find($data['id']);
            }

            $setting->key = $data['key'];
            $setting->value = $data['value'];

            $setting->save();
        } catch (\Exception $e) {
            $response->result = false;
            $response->messages[] = $e->getMessage();
        }

        return response()->json($response, $response->result ? 200 : 422);
    }

    public function delete()
    {
        $data = request()->all();

        $response = new \stdClass;
        $response->result = true;
        $response->messages = [];
        $response->data = false;

        try {
            $setting = Setting::find($data['id']);
            $setting->delete();
        } catch (\Exception $e) {
            $response->result = false;
            $response->messages[] = $e->getMessage();
        }

        return response()->json($response, $response->result ? 200 : 422);
    }
}