<?php

namespace Ignite\Claim\Entities;

use Illuminate\Database\Eloquent\Model;
use Ignite\Claim\Traits\ValidatesFields;

class RuleLog extends Model
{
	use ValidatesFields;

	/**
	 * The table name.
	 * @var string
	 */
	protected $table = 'claim_rule_log';

	/**
	 * The primary key.
	 * @var string
	 */
	protected $primaryKey = 'id';

	/**
	 * The field declarations.
	 * @var array
	 */
    public static $fields = [
        'id'                    => [ 'type' => 'integer'],
        'claim_participant_id'  => [ 'type' => 'integer'],
        'log_text'              => [ 'type' => 'string'],
    ];

	/**
	 * The relationship to the claim participant model.
	 *
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
    public function claim_participant()
    {
        return $this->belongsTo(\Ignite\Claim\Entities\ClaimParticipant::class, 'claim_participant_id');
    }
}
