<?php

namespace Ignite\Claim\Models\Grid;

class ParticipantClaimTable extends ClaimTable
{
    /**
     * The report query.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())->keyBy('name')->except('actions')->keys()->toArray();

        $query = $this->getConnection()->table('claim_participant')
            ->select($columns)
            ->distinct()
            ->leftJoin('claim', 'claim.id', '=', 'claim_participant.claim_id')
            ->leftJoin('core_participant as participant', 'participant.user_id', '=', 'claim_participant.user_id')
            ->leftJoin('core_user', 'core_user.user_id', '=', 'claim_participant.user_id')
            ->whereNull('claim_participant.deleted_at')
            ->where('claim_participant.user_id', $this->user_id);

        if ($this->status !== 'all') {
            $query->where('claim_participant.status', $this->status);
        }

        return $this->applyScopes($query);
    }
}
