<?php

return [
    'name' => 'Claim',

    'disk' => env('CLAIM_STORAGE_DISK', 'local'),

    'import' => [
        'types' => [
            'claim' => [
                'class' => '\Ignite\Claim\Services\Importer',
                'label' => 'Claim'
            ]
        ]
    ],

    'stats' => [
        'class' => \Ignite\Claim\Models\Summary\Metric::class,
        'statuses' => [
            'approved', 'pending', 'declined', 'issued'
        ]
    ],

    'additional_recipients' => [],

    'report' => [
        'filters' => [
            \Ignite\Claim\Models\Report\ClaimReport::class => [
                'view' => 'Core::admin.report.filters.daterange',
                'scope' => \Ignite\Core\Models\Grid\Scopes\DateScope::class,
                'request' => ['field', 'startDate', 'endDate'],
                'options' => [
                    'claim.activity_date' => 'Claim Activity Date',
                    'claim.date_submitted' => 'Claim Submitted Date',
                    'claim.created_at' => 'Claim Created At',
                    'claim_participant.date_submitted' => 'Claim Participant Submitted At',
                    'claim_participant.date_approved' => 'Claim Participant Approved At',
                    'claim_participant.issued_at' => 'Claim Participant Issued At',
                    'claim_participant.declined_at' => 'Claim Participant Declined At',
                    'claim_participant.cancelled_at' => 'Claim Participant Cancelled At',
                    'claim_participant.created_at' => 'Claim Participant Created At',
                    'participant.created_at' => 'Participant Created At',
                    'participant.approved_at' => 'Participant Approved At',
                    'user.created_at' => 'User Created At',
                ]
            ],
        ]
    ]
];
