@extends('Claim::layouts.forms')

@php $pageTitle = 'Edit ' . ucwords(str_replace('_', ' ', $formColumns->name)). ' Form '; @endphp

@section('page_heading', $pageTitle)
@section('page_breadcrumb', $pageTitle)

@section('page_content')

<div class="box box-primary">
    <div class="box-header with-border">
        <h3 class="box-title">
            {{ $pageTitle }}
        </h3>
    </div>
    <div class="box-body" id="data-table-height">
        <button type="button" class="btn btn-default" id="addColumn" data-name="new"><span class="fa fa-plus text-success"></span> <span class="text-success">Create</span></button>
        <hr />
        <table class="table table-striped table-responsive data-table" id="columnsTable">
            <thead>
                <tr>
                    <th class="text-left">
                        No. Of Columns:
                        <span style="padding-left: 1.0rem;" id="columnCount"></span>
                    </th>
                    <th>Table</th>
                    <th>Column Name</th>
                    <th>Display Name</th>
                    <th>Type</th>
                    <th>Required</th>
                    <th>Order</th>
                </tr>
            </thead>
            <tbody>
            @foreach(collect($formColumns->columns)->collapse()->sortBy('order', SORT_NUMERIC) as $column)
                <tr data-column_name="{{ $column['table'] . '-' . $column['name'] }}">
                    <td class="text-left" nowrap width="150">
                        <button type="button" class="btn btn-sm btn-default editColumn" data-column_name="{{ $column['table'] . '-' . $column['name'] }}" >
                            Edit
                        </button>
                        <button type="button" class="btn btn-sm btn-danger deleteColumn" data-column_name="{{ $column['table'] . '-' . $column['name'] }}" >
                            Delete
                        </button>
                    </td>
                    <td data-name="table">{{ $column['table'] }}</td>
                    <td data-name="name">{{ $column['name'] }}</td>
                    <td data-name="displayName">{{ $column['displayName'] }}</td>
                    <td data-name="type">{{ $column['type'] }}</td>
                    <td data-name="required" data-boolean="1">{{ (( $column['required'] ) ? 'Y' : '' ) }}</td>
                    <td data-name="order">{{ (( isset($column['order']) ) ? $column['order'] : '') }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div class="box-footer">
        <button type="button" class="btn btn-danger pull-left" id="cancelForm">Cancel</button>
        <button type="button" class="btn btn-primary pull-right" id="saveForm">Save</button>
    </div>
</div>

<!-- Modal Edit Dialog -->
<div class="modal " id="columnEditDialog" tabindex="-1" role="dialog" aria-labelledby="columnEditLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h3 class="modal-title" id="columnEditLabel">Column Details</h3>
            </div>
            <div class="modal-body">
                <form id="editColumnForm">
                    {{ csrf_field() }}
                    <input type="hidden" id="editMode" value="" />
                    <div class="form-group">
                        <label for="columnOrder">Show Order</label>
                        <input type="text" class="form-control" id="columnOrder" name="columnOrder" data-name="order">
                    </div>

                    <div class="form-group">
                        <label for="columnTable">Table Name</label>
                        <select class="form-control addMode" id="columnTable" name="columnTable" data-name="table" required>
                            <option value="">--- select ---</option>
                            @foreach($tableColumns as $tableName => $columns)
                            <option value="{{ $tableName }}">{{ $tableName }}</option>
                            @endforeach
                        </select>
                        <div class="controls readOnlyText editMode" id="columnTable" name="columnTable" data-name="table">
                        &nbsp;
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="columnName">Column Name</label>
                        <select class="form-control addMode" id="columnName" name="columnName" data-name="name" required>
                            <option value="">--- select ---</option>
                        </select>
                        <div class="controls readOnlyText editMode" id="columnName" name="columnName" data-name="name">
                            &nbsp;
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="columnDisplayName">Display Name</label>
                        <input type="text" class="form-control" id="columnDisplayName" name="columnDisplayName" data-name="displayName" />
                    </div>

                    <div class="form-group">
                        <label for="columnType">Form Field Type</label>
                        <select class="form-control" id="columnType" name="columnType" data-name="type" required>
                            <option value="">--- select ---</option>
                            @foreach($formColumnTypes as $type => $params)
                            <option value="{{ $type }}">{{ $type }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="columnRequired" class="col-md-3">Required</label>
                        <input type="checkbox" id="columnRequired" name="columnRequired" data-name="required" value="1" />
                    </div>

                    <div class="form-group">
                        <label for="columnHelpText">Help Text</label>
                        <textarea rows="10" class="form-control" id="columnHelpText" name="columnHelpText" data-name="helpText"></textarea>
                    </div>

                    <div class="form-group">
                        <label for="columnDefault">Default Value</label>
                        <input type="text" class="form-control" id="columnDefault" name="columnDefault" data-name="default" />
                    </div>

                    <div class="form-group">
                        <label for="columnFormat">Format</label>
                        <input type="text" class="form-control" id="columnFormat" name="columnFormat" data-name="format" />
                    </div>

                    <div class="form-group">
                        <label for="columnValidateType">Validation Type</label>
                        <select class="form-control" id="columnValidateType" name="columnValidateType" data-name="validateType">
                            <option value="">--- select ---</option>
                            @foreach($validateTypes as $type => $params)
                            <option value="{{ $type }}">{{ $type }}</option>
                            @endforeach
                        </select>
                        <div class="form-group hidden" id="customValidate">
                            <br />
                            <label for="columnValidate">Custom Laravel Validation String</label>
                            <input type="text" class="form-control" id="columnValidate" name="columnValidate" data-name="validate" />
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-primary hidden" id="columnSave">Save</button>
                <button type="button" class="btn btn-primary hidden" id="columnAdd">Add</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('js')
@parent
<script src="{{ asset('/vendor/ignite/js/dynamic/dynamic.js') }}"></script>
<script>

var dirtyFlag = false;
var formFields = {!! json_encode($formFields, JSON_PRETTY_PRINT) !!} ;
var formColumns = {!! json_encode($formColumns, JSON_PRETTY_PRINT) !!} ;
var tableColumns = {!! json_encode($tableColumns, JSON_PRETTY_PRINT) !!} ;

$(document).ready(function(){
    /*var alertDevBox = $('.alert-dev').length ? $('.alert-dev').outerHeight() : 0;
    $('#data-table-height').css({
        maxHeight: $('.content-wrapper').outerHeight() - $('.main-header').outerHeight() - $('.content-header').outerHeight() - alertDevBox - $('.box-header').outerHeight() - $('.box-footer').outerHeight()
    })*/

    function clearColumnEditDialog()
    {
        var count = parseInt($('#columnCount').html());

        $('#columnOrder').val(count + 1);

        // Save most recent Table Name
        var tableName = $('#columnTable').val();

        editColumnValidator.resetForm();
        $('#columnEditDialog [data-name]').removeClass('error');

        // Restore most recent Table Name
        $('#columnTable').val(tableName);
        $('#columnName').val('');
        $('#columnDisplayName').val('');
        $('#columnType').val('');
        $('#columnRequired').attr('checked', false);
        $('#columnFormat').val('');
        $('#columnDefault').val('');
        $('#columnHelpText').val('');
        $('#columnValidateType').val('');
        $('#columnValidate').val('');
    }

    function updateColumnCount()
    {
        updateRowCount('columnCount', 'columnsTable');
        showHideNoRows('columnCount', 'columnsTable', 'No columns found.');
    }

    function setColumnDialogMode(mode)
    {
        $('#columnEditDialog #editMode').val(mode);

        $('#columnEditDialog .modal-header').removeClass('bg-default');
        $('#columnEditDialog .modal-header').removeClass('bg-success');

        // Show / Hide appropriate Input Fields
        // Column Name is always Read Only on an Edit
        if ( mode == 'edit' ) {
            $('#columnEditDialog .addMode').addClass('hidden');
            $('#columnEditDialog .editMode').removeClass('hidden');
            $('#columnEditDialog .addMode').hide();
            $('#columnEditDialog .editMode').show();
        }
        else {
            $('#columnEditDialog .editMode').addClass('hidden');
            $('#columnEditDialog .addMode').removeClass('hidden');
            $('#columnEditDialog .editMode').hide();
            $('#columnEditDialog .addMode').show();
        }

        // Show / Hide appropriate Action Buttons
        if ( mode == 'add' ) {
            $('#columnEditDialog .modal-header').addClass('bg-success');
            $('#columnEditDialog #columnEditLabel').html('Add Column');

            $('#columnSave').addClass('hidden');
            $('#columnSave').hide();
            $('#columnAdd').removeClass('hidden');
            $('#columnAdd').show();
        }
        else {
            $('#columnEditDialog .modal-header').addClass('bg-default');
            $('#columnEditDialog #columnEditLabel').html('Edit Column');

            $('#columnAdd').addClass('hidden');
            $('#columnAdd').hide();
            $('#columnSave').removeClass('hidden');
            $('#columnSave').show();
        }
    }

    function buildColumnRow(data)
    {
        var html = '';
        var columnName = data['table'] + '-' + data['name'];

        html += '<tr data-column_name="' + columnName + '">' + "\n";
        html += '  <td align="left" nowrap>' + "\n";
        html += '    <button type="button" class="btn btn-sm btn-default editColumn" data-column_name="' + columnName + '" >Edit</button>' + "\n";
        html += '    <button type="button" class="btn btn-sm btn-danger deleteColumn" data-column_name="' + columnName + '" >Delete</button>' + "\n";
        html += '  </td>' + "\n";
        html += '  <td data-name="table">' + data['table'] + '</td>' + "\n";
        html += '  <td data-name="name">' + data['name'] + '</td>' + "\n";
        html += '  <td data-name="displayName">' + data['displayName'] + '</td>' + "\n";
        html += '  <td data-name="type">' + data['type'] + '</td>' + "\n";
        html += '  <td data-name="required" data-boolean="1">' + (( data['required'] ) ? 'Y' : '' ) + '</td>' + "\n";
        html += '  <td data-name="order">' + data['order'] + '</td>' + "\n";
        html += '</tr>' + "\n";

        return html;
    }

    function editColumn(element)
    {
        // Get the Column selected
        var parts = $(element).attr('data-column_name').split('-');
        var tableName = parts[0];
        var columnName = parts[1];

        clearColumnEditDialog();
        setColumnDialogMode('edit');

        var params = formColumns.columns[tableName][columnName];

        populateEditColumnDialog(params, 'columnEditDialog');

        $('#columnEditDialog').modal('show');
    }

    function updateTableRow(showAlerts)
    {
        var result = true;
        var tableName = $('#columnEditDialog div[data-name="table"]').html();
        var columnName = $('#columnEditDialog div[data-name="name"]').html();

        var params = formColumns.columns[tableName][columnName];
        var data = retrieveEditColumnDialog(params, 'columnEditDialog');

        formColumns.columns[tableName][columnName] = data;

        var colName = tableName + '-' + columnName;
        var $row = $('#columnsTable tr[data-column_name="' + colName + '"]');

        for (var name in data) {
            var value = data[name];
            var $formField = $row.find('[data-name="' + name + '"]');
            var rc = setFormField($formField, name, value, showAlerts);
            console.log(rc);
            /*if (! rc) {
                result = false;
            }*/
        }

        columnsDataTable.row($row).invalidate().draw();

        return result;
    }

    function saveColumn(showAlerts)
    {
        dirtyFlag = true;

        return updateTableRow(showAlerts);
    }

    function addColumn(columnsDataTable)
    {
        dirtyFlag = true;
        var result = true;
        var tableName = $('#columnEditDialog select[data-name="table"]').val();
        var columnName = $('#columnEditDialog select[data-name="name"]').val();

        if (
            typeof(formColumns.columns[tableName]) != 'undefined' &&
            typeof(formColumns.columns[tableName][columnName]) != 'undefined'
        ) {
            alert("Duplicate Table / Column = '" + tableName + '.' + columnName + "'.\nPlease select different Table / Column name combination.");
            return false;
        }

        var params = formFields;
        var data = retrieveEditColumnDialog(params, 'columnEditDialog');

        if (typeof(formColumns.columns[tableName]) == 'undefined') {
            formColumns.columns[tableName] = {};
        }

        formColumns.columns[tableName][columnName] = data;

        var html = buildColumnRow(data);
        var $row = $(html);

        $row.find('.editColumn').click(function() {
            editColumn(this);
        });

        $row.find('.deleteColumn').click(function() {
            deleteColumn(this);
        });

        columnsDataTable.row.add($row);

        $('#columnsTable tbody').append($row);

        updateColumnCount();
        updateDataTables(columnsDataTable);

        $('#columnEditDialog').modal('hide');

        return result;
    }

    function deleteColumn(element)
    {
        var $row = $(element).closest('tr');
        var tableName = $row.find('td[data-name="table"]').html();
        var columnName = $row.find('td[data-name="name"]').html();
        var rc = window.confirm("Are you sure you want to delete the Form Column:\nTable = '" + tableName + "', Column = '" + columnName + "' ?");
        if (! rc) {
            return false;
        }

        dirtyFlag = true;

        delete formColumns.columns[tableName][columnName];

        columnsDataTable.row($row).remove();

        $row.remove();

        updateColumnCount();
        updateDataTables();
    }

    function saveForm()
    {
        var data = {
            id: formColumns.id,
            key: formColumns.key,
            _token: $('[name=_token]').val(),
            columns: {}
        };

        for (var i in formColumns.columns) {
            data.columns[i] = formColumns.columns[i];
        }

        $.ajax({
            type: 'POST',
            url: '/admin/settings/forms/api/store',
            data: data,
            dataType: 'json',
            success: function(result){
                $(window).off('beforeunload');
                document.location = '/admin/settings/forms';
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert('Unable to Save Form = ' + formColumns.name + "\n" + xhr.status + ': ' + thrownError);
            }
        });
    }

    function updateColumnSelect(tableName) {
        $('#columnName').empty();

        var html = '<option value="">-- Select --</option>' + "\n";
        for (var key in tableColumns[tableName]) {
            var column = tableColumns[tableName][key];
            html += '<option value="' + column.name + '">' + column.name + '</option>' + "\n";
        }

        $('#columnName').html(html);
    }

    function updateDataTables(columnsDataTable) {
        columnsDataTable.order(dataTablesSort).draw();
    }



    $(window).on('beforeunload', function() {
        if ( dirtyFlag ) {
            return "You have unsaved changes.\nAre you sure you want to leave this page?";
        }
    });

    $(document).off('show.bs.modal', '#columnEditDialog');

    var editColumnValidator = $('#editColumnForm').validate();
    var dataTablesSort = [[6, 'asc']];
    var columnsDataTable = $('#columnsTable').DataTable({
        "serverSide": false,
        "columnDefs": [{orderable: false, targets: [6]}],
        "pageLength": 100,
        "order": dataTablesSort
    }).on('preDraw', function () {
        return false;
    });

    $('#columnValidateType').change(function() {
        var type = $(this).val();

        if (type == 'custom') {
            $('#columnEditDialog #customValidate').removeClass('hidden');
            $('#columnEditDialog #customValidate').show();
        } else {
            $('#columnEditDialog #customValidate').addClass('hidden');
            $('#columnEditDialog #customValidate').hide();
        }
    });

    $('#columnTable').change(function() {
        var tableName = $(this).val();
        updateColumnSelect(tableName);
    });

    $('.editColumn').click(function() {
        editColumn(this);
    });

    $('.deleteColumn').click(function() {
        deleteColumn(this);
    });

    $('#addColumn').click(function() {
        clearColumnEditDialog();
        setColumnDialogMode('add');

        $('#columnEditDialog').modal('show');
    });

    $('#columnSave').click(function() {
        var rc;
        var showAlerts = false;

        rc = saveColumn(showAlerts);

        if (rc) {
            $('#columnEditDialog').modal('hide');
        }
    });

    $('#columnAdd').click(function() {
        if ( ! $("#editColumnForm").valid() )
            return false;

        addColumn(columnsDataTable);
    });

    $('#cancelForm').click(function() {
        if (dirtyFlag) {
            var rc = window.confirm("You have unsaved changes.\nAre you sure you want to leave this page?");
            if (! rc) {
                return false;
            }
        }

        if (! formColumns.id) {
            document.location = '/admin/settings/forms/create';
        } else {
            document.location = '/admin/settings/forms';
        }
    });

    $('#saveForm').click(function() {
        saveForm();
    });

    updateColumnCount();
});

</script>

@endsection

