<?php

namespace Ignite\Claim\Models;

class Scramble
{
    /**
     * Scramble takes a string and returns a scrambled version 3 times as long.
     *
     * @param  string $string
     * @param  string $key
     * @return string
     */
    public static function scramble($string, $key = '')
    {
        $length = strlen($string);
        $keyLength = strlen($key);
        $randChars = "abcdefghijklmnopqrstuvwxyz0123456789";
        $randLength = strlen($randChars) - 1;
        $scrambled = "";

        for ($ii = $length - 1; $ii >= 0; --$ii) {
            $oneChar = $string[ $ii ];
            $strCharValue = ord($oneChar);

            if ($key != "") {
                // $pos = $ii % $keyLength;
                $keyCharValue = ord($key[$ii % $keyLength]);
                $strCharValue += $keyCharValue;

                if ($strCharValue > 256) {
                    $strCharValue -= 256;
                }
            }

            $randChar = $randChars[rand(0, $randLength)];
            $twoChar = sprintf("%2x", $strCharValue);

            $charOne = $twoChar[0];
            $charTwo = $twoChar[1];

            $mod = $ii % 3;

            switch ($mod) {
                case 0:
                    $threeChars = $randChar . $charTwo . $charOne;
                    break;
                case 1:
                    $threeChars = $charOne . $randChar . $charTwo;
                    break;
                case 2:
                    $threeChars = $charTwo . $charOne . $randChar;
                    break;
            }

            $scrambled .= $threeChars;
        }

        return $scrambled;
    }

    /**
     * Unscramble takes a string produced by Scramble and returns the original string 3 times shorter.
     *
     * @param string $string
     * @param string $key
     * @return string
     */
    public static function unscramble($string, $key = '')
    {
        if (substr($string, 0, 2) == "#&") {
            $string = substr($string, 2);
        }

        $length = strlen($string);
        $keyLength = strlen($key);
        $count = $length / 3;
        $unscrambled = '';

        for ($ii = 0; $ii < $count; ++$ii) {
            $offset = $ii * 3;
            $threeChar = substr($string, $offset, 3);
            $charOne   = (! empty($threeChar[0])) ? $threeChar[0] : '#';
            $charTwo   = (! empty($threeChar[1])) ? $threeChar[1] : '#';
            $charThree = (! empty($threeChar[2])) ? $threeChar[2] : '#';
            $mod = ($count - $ii - 1) % 3;

            switch ($mod) {
                case 0:
                    $hexChars = $charThree . $charTwo;
                    break;
                case 1:
                    $hexChars = $charOne . $charThree;
                    break;
                case 2:
                    $hexChars = $charTwo . $charOne;
                    break;
            }

            $number = sscanf($hexChars, "%x");

            if ($key != "") {
                $keyCharValue = ord($key[($count - $ii - 1) % $keyLength]);
                $number[0] -= $keyCharValue;

                if ($number[0] < 0) {
                    $number[0] += 256;
                }
            }

            $oneChar = chr($number[0]);
            $unscrambled = $oneChar . $unscrambled;
        }

        return $unscrambled;
    }
}
