<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClaimOfferPromotionCapTable extends Migration
{
    protected $tableName = 'claim_offer_promotion_cap';
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedInteger('offer_promotion_id');
            $table->string('name', 100);
            $table->string('description', 500)->nullable();
            $table->dateTime('start_date')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->integer('fiscal_month')->default(1);
            $table->string('max_period', 20)->nullable();
            $table->integer('value_type_id')->default(1);
            $table->double('max_value');
            $table->integer('status')->default(0);
            $table->timestamps();
            $table->foreign('offer_promotion_id')->references('id')->on('claim_offer_promotion');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop($this->tableName);
    }
}
