@extends('Claim::layouts.entry')

@section('page_heading', 'Process Claims')
@section('page_breadcrumb', 'Process Claims')

@section('page_content')
    <div id="claims-processing">
        <div class="box box-primary">
            <div class="box-body">
                <form action="{{ route('admin.claim.process.update') }}" method="post" name="selected" id="selected">
                    <input id="selected-items" type="hidden" name="items" value=""/>
                    <input id="selected-status" type="hidden" name="status" value=""/>
                    <input id="selected-reason" type="hidden" name="reason" value=""/>
                    {{ csrf_field() }}
                </form>
                {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            </div>
        </div>
    </div>
    @include('Claim::partials.dialog.reason')
    @include('Claim::partials.dialog.quickview')
@endsection

@section('js')
    @parent
    {!! $dataTable->scripts() !!}
    <script src="{{ asset('vendor/ignite/js/claim/process/reason-modal.js') }}"></script>
    <script type="text/javascript">
      jQuery(document).ready(function($) {

        $('#selected-items, #selected-status, #selected-reason').val('');

        var $dataTable = $('#dataTableBuilder');
        $dataTable.customButtons({
          buttons: [{
            enabled: false,
            text: '<span class="fa fa-times text-danger"></span> <span class="text-danger button-text-decline">Decline</span>',
            action: function (e, dt, node, conf) {
              e.preventDefault();
              var selected = dt.column(0).checkboxes.selected();
              new window.ReasonModal({
                required: true,
                titleText: 'Decline Claim Participants',
                labelText: 'Reason for Decline',
                buttonText: 'Decline',
                onSuccess: $.proxy(function (reason) {
                  $('#selected-reason').val(reason);
                  $('#selected-status').val('declined');
                  $('#selected-items').val(selected.map(function (box) {
                    return $(box).val();
                  }).join(','));
                  $('#reason-submit-message').removeClass('hide').text('Submitting...please wait');
                  $('#reason-note-field').addClass('hide');
                  $('#selected').submit();
                  $('#reason-dialog-proceed').text('Declining...').prop('disabled', true);
                }, this),
                onFailure: $.proxy(function (reason, error) {
                  error.text('Please enter a useful reason for declining the claim.')
                }, this)
              });
            }
          }, {
            enabled: false,
            text: '<span class="fa fa-check text-success"></span> <span class="text-success button-text-approve">Approve</span>',
            action: function (e, dt, node, conf) {
              e.preventDefault();
              $(node).prop('disabled', true);
              $(node).find('.button-text-approve').text('Approving...');
              var selected = dt.column(0).checkboxes.selected();
              $('#selected-status').val('approved');
              $('#selected-items').val(selected.map(function (box) {
                return $(box).val();
              }).join(','));
              $('#selected').submit();
            }
          }]
        });

        $(document).on('click', '.btn-view',  function(e) {
          e.preventDefault();
          var url = $(this).attr('href');
          $.ajax({
            url: url,
            type: 'GET',
            success: function(data, textStatus, jqXHR) {
              var dialog = $('#quickview-dialog');
              dialog.modal('show');
              dialog.find('.modal-body').html(data);
              $('#quickview-dialog-edit').attr('href', url.replace('quickview', 'edit'));
            }
          });
        });
      });
    </script>
@endsection
